/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___NETMAPPER_H___
#define ___NETMAPPER_H___

#include	"avt.h"
#include	"xl.h"

typedef struct nm_edge_v {
	struct nm_edge_v *	next;
	struct nm_vertex *	v;
	struct nm_edge *	this;
} NM_EDGE_V;

typedef struct nm_edge {
	NM_EDGE_V		ev[2];
} NM_EDGE;

typedef struct name_ptr {
	double		x;
	double		y;
} NAME_PTR;

typedef struct nm_vertex {
	struct nm_vertex *	next;
	int			size;
	void *			name;
	NM_EDGE_V *		edge;
	struct nm_vertex *	co;
	struct nm_vertex *	loop_next;
	int			flags;
#define VF_LOOP		0x00000001
} NM_VERTEX;

typedef struct nm_target {
	NM_VERTEX *		vertex;
	short			name_type;
#define NMT_PTR		1
#define NMT_STR		2
	int			(*avt_cmp)();
	AVT_NODE *		tree;
	double			tolerance;
} NM_TARGET;

typedef struct nm_loop {
	struct nm_loop *	loop_next;
	struct nm_loop *	next;
	NM_VERTEX *		v;
	int			length;
	struct nm_loop *	work_next;
} NM_LOOP;

typedef struct backup_header {
	int			type;
} BACKUP_HEADER;

#define BT_EDGE		0

typedef struct backup_vertex {
	int			type;
#define BT_VERTEX	1
	NAME_PTR		ptr;
} BACKUP_VERTEX;

void init_target(NM_TARGET * t,short name_type);
NM_VERTEX * new_vertex(NM_TARGET * t,void * name,int size);
NM_EDGE * new_edge(NM_TARGET * t,NM_VERTEX * p1,NM_VERTEX * p2);
void clean_ve(NM_TARGET * t);
XL_SEXP * output_mapping();

extern NM_TARGET net_target[];
extern int loading_target;
extern int backup_fid;

#endif
