/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"
#include	"kyotodb.h"
#include	"favt.h"
#include	"dtree.h"

XL_SEXP * xl_alias();

void
init_alias(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"alias"),
		get_func_prim(xl_alias,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_alias(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * from;
XL_SEXP * to;
int er;
	from = get_el(s,1);
	to = get_el(s,2);
	if ( get_type(from) != XLT_STRING )
		goto type_missmatch;
	if ( get_type(to) != XLT_STRING )
		goto type_missmatch;
	er = dtree_alias(from->string.data,to->string.data);
	switch ( er ) {
	case -1:
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNDEF_RESOURCE,
			l_string(std_cm,"alias"),
			n_get_string("copy src is not exist"));
	case -2:
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_RESOURCE,
			l_string(std_cm,"alias"),
			n_get_string("copy dest is already exist"));
	case 0:
		break;
	default:
		er_panic("xl_alias");
	}
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"alias"),
		0);

}


