/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	"xlerror.h"
#include	"xl.h"
#include	"kyotodb.h"
#include	"favt.h"
#include	"dtree.h"

XL_SEXP * xl_kyotodb();

void
init_kyotodb(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"kyotodb"),
		get_func_prim(xl_kyotodb,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_kyotodb(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV *a,XL_SYM_FIELD * sf)
{
int oflags;
	oflags = O_CREAT|O_TRUNC;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"type")) == 0 ) {
			if ( l_strcmp(sf->data,l_string(std_cm,"new")) == 0 )
				oflags = O_CREAT|O_TRUNC;
			else if ( l_strcmp(sf->data,
					l_string(std_cm,"update")) == 0 )
				oflags = 0;
		}
	}
	init_k_table(oflags);
	return 0;
}


