/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"memory_debug.h"
#include	"xl.h"
#include	"xl2pdb_p.h"



XL_SEXP * xl_line_color();

void
init_line_color(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"line-color"),
		get_func_prim(xl_line_color,FO_APPLICATIVE,0,2,5));
}

XL_SEXP *
pdb_color(GB_COLOR * cl,XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf);

XL_SEXP *
xl_line_color(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
PDB_POLYGON2D * p;
XL_SEXP * ret;
	p = get_polygon(&ret,sf,s->h.file,s->h.line);
	if ( p == 0 )
		return ret;
	return pdb_color(&p->line,env,s,a,sf);
}
