/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_CloseInterpreter();

void
init_CloseInterpreter(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"CloseInterpreter"),
		get_func_prim(xl_CloseInterpreter,
			      FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_CloseInterpreter(XLISP_ENV * env,XL_SEXP * s)
{
unsigned int _id;
XL_SEXP * id;
XL_INTERPRETER * xli;
	id = get_el(s,1);
	switch ( get_type(id) ) {
	case XLT_ERROR:
		return id;
	case XLT_INTEGER:
		break;
	default:
		goto type_missmatch;
	}
	_id = id->integer.data;
	close_interpreter(_id);
	return 0;
invalid_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"CloseInterpreter"),
		n_get_string("id is minus number"));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"CloseInterpreter"),
		0);
}


