/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_NewEnvPair();

void
init_NewEnvPair(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"NewEnvPair"),
		get_func_prim(xl_NewEnvPair,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_NewEnvPair(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * e1, * e2;
	e1 = get_el(s,1);
	if ( get_type(e1) != XLT_ENV )
		goto type_missmatch;
	e2 = get_el(s,2);
	if ( get_type(e2) != XLT_ENV )
		goto type_missmatch;
	return get_env(new_env_pair(e1->env.data,e2->env.data));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"NewEnvPair"),
		0);
}


