/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP *
xl_SetResultFormat(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a_env,
	XL_SYM_FIELD * sf);

void
init_SetResultFormat(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SetResultFormat"),
		get_func_prim(xl_SetResultFormat,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_SetResultFormat(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a_env,
	XL_SYM_FIELD * sf)
{
XL_INTERPRETER * xli;
int flags;
int mask;
XL_SEXP * ret;
int a;
	flags = 0;
	mask = 0;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"indent")) == 0 ) {
			if ( l_strcmp(sf->data,l_string(std_cm,"on")) == 0 ) {
				mask |= PF_INDENT;
				flags |= PF_INDENT;
			}
			else if ( l_strcmp(sf->data,l_string(std_cm,"off"))
					== 0 ) {
				mask |= PF_INDENT;
				flags &= ~PF_INDENT;
			}
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"mode")) == 0 ) {
			if ( l_strcmp(sf->data,l_string(std_cm,"lisp"))
						== 0 ) {
				flags &= ~PFM_FORMAT;
				mask |= PFM_FORMAT;
				flags |= PF_LISP;
			}
			else if ( l_strcmp(sf->data,
					l_string(std_cm,"xml")) == 0 ) {
				flags &= ~PFM_FORMAT;
				mask |= PFM_FORMAT;
				flags |= PF_XML;
			}
			else if ( l_strcmp(sf->data,
					l_string(std_cm,"html")) == 0 ) {
				flags &= ~PFM_FORMAT;
				mask |= PFM_FORMAT;
				flags |= PF_HTML;
			}
		}
	}
	xli = get_my_xli();
	xli->ps_flags &= ~mask;
	xli->ps_flags |= flags;

	ret = 0;
	if ( xli->ps_flags & PF_INDENT )
		ret = cons(n_get_string("indent:on"),ret);
	else	ret = cons(n_get_string("indent:off"),ret);
	switch ( xli->ps_flags & PFM_FORMAT ) {
	case PF_LISP:
		ret = cons(n_get_string("mode:LISP"),ret);
		break;
	case PF_XML:
		ret = cons(n_get_string("mode:XML"),ret);
		break;
	case PF_HTML:
		ret = cons(n_get_string("mode:HTML"),ret);
		break;
	}
	return ret;
}


