/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"
#include	"task.h"

extern SEM gb_env_lock;

UNIT_ENV *
_get_uenv(XLISP_ENV * env)
{
UNIT_ENV * ret;
	for ( ; env ; ) {
		switch ( env->type ) {
		case GBET_PAIR:
			ret = _get_uenv(env->p.env[0]);
			if ( ret )
				return ret;
			return _get_uenv(env->p.env[1]);
		case GBET_ENV:
			if ( env->e.uenv )
				return env->e.uenv;
			env = env->e.parent;
			break;
		default:
			er_panic("get_uenv");
		}
	}
	return 0;
}

UNIT_ENV *
get_uenv(XLISP_ENV * env)
{
UNIT_ENV * ret;
	lock_task(gb_env_lock);
	ret = _get_uenv(env);
	unlock_task(gb_env_lock,"get_uenv");
	return ret;
}



void
set_uenv(XLISP_ENV * env,UNIT_ENV * ue)
{
	lock_task(gb_env_lock);
	env->e.uenv = ue;
	unlock_task(gb_env_lock,"set_uenv");
}
