/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___RADAR_H___
#define ___RADAR_H___

#include	"gbgraph.h"
#include	"gbview.h"
#include	"queue.h"
#include	"lump.h"

#define RADAR_CACHE_SIZE		100
#define RADAR_MATRIX_CACHE_SIZE		100
#define RADAR_DOTS			500
#define RADAR_DOTS_RATE			1.5
#define CLEAR_INTERVAL			50
#define WIN_SURF_RATE_MIN		4
#define WIN_SURF_RATE_MAX		5

#define WIN_RESO_WINDOW_MIN		2
#define WIN_RESO_WINDOW_MAX		1000

#define BEAM_TASKS			10

/* sethomestatus
#define OPENING_TIMEOUT			5

#define OS_GENESIS	0
#define OS_STANBY	1
#define OS_SETHOME	2
#define OS_SETHOME_COMPLETE	3
#define OS_RUN		4
#define OS_MAX		5
*/

typedef struct lump_crd_node {
	struct lump_crd_node *	lump_next;
	struct lump_crd_node *	crd_next;
	struct radar_lump *	lump;
	struct radar_crd *	crd;
} LUMP_CRD_NODE;

typedef struct radar_lump {
	struct radar_lump *	next;
	L_CHAR *		lumpcrd_path;
	L_CHAR *		db_path;
	GB_RECT			sphere;
	REAL1			reso_min;
	REAL1			reso_max;
	LUMP_CRD_NODE *		crd;
} RADAR_LUMP;

typedef struct radar_node {
	struct radar_node *	crd_next;
	struct radar_node *	matrix_next;
	struct radar_crd *	crd;
	struct radar_matrix *	matrix;
} RADAR_NODE;

typedef struct radar_crd {
	int			bufid;
	int			lock;
	struct radar_crd *	next;
	struct radar_crd *	prev;
	int			flags;
#define RCF_INMATRIX		0x00000001
	REAL1			resolution;
	GB_RECT			minrect;
	L_CHAR *		crd_path;
	L_CHAR *		obj_path;
	RESOURCE *		crd_r;
	RESOURCE *		obj_r;
	BIB_LIST *		crd_bib;
	BIB_LIST *		obj_bib;
	RADAR_NODE *		list;
	L_CHAR *		base_url;
	LUMP_CRD_NODE *		lump;
	int			lump_handling;
} RADAR_CRD;

typedef struct radar_matrix {
	struct radar_matrix *	next;
	struct radar_matrix *	prev;
	REAL1			resolution;
	/* resolution - 2*resolution */
	REAL1			loaded_reso;
	GB_RECT			rect[2][2];
	struct radar_matrix *	mx[2][2];
	RADAR_NODE *		list;
	struct radar_matrix *	parent;
} RADAR_MATRIX;


typedef struct t_load_to_beam {
	Q_HEADER		h;
	XL_SEXP *		query;
	GB_RECT			r;
	REAL1			min;
	REAL1			max;
	L_CHAR *		base_url;
	RADAR_LUMP *		rl;
} T_LOAD_TO_BEAM;

typedef struct t_beam_to_resource {
	Q_HEADER		h;
	XL_SEXP *		urls;
} T_BEAM_TO_RESOURCE;

typedef struct t_resource_to_insert {
	Q_HEADER		h;
	LOAD_RESOURCE_WORK *	lr_crd;
	LOAD_RESOURCE_WORK *	lr_obj;
	int			mappath_loading;
	L_CHAR *		crd_path;
	L_CHAR *		obj_path;
} T_RESOURCE_TO_INSERT;



typedef struct radar_cache {
	int			status;
	GBVIEW_FLAME *		gf;

	RADAR_MATRIX		mtx_h;
	RADAR_CRD *		free_list;
	RADAR_CRD *		crd;
	GB_POINT *		ptr;
	REAL1 *			res;
	RADAR_MATRIX *		matrix;
	int			matrix_count;
	L_CHAR *		base_url;
	int			base_url_lock;
	int			base_url_lock_task;
	GB_RECT			win_rect;
	REAL1			win_reso_window;
	REAL1			win_reso_max;
	char			win_remake;
	char			win_force;
	char			win_load;
	char			win_delete_lock;
	char			retrieve_flag;
	int			lock;

	int			task_mode;
#define TM_MIN		0
#define TM_WMAN		1
#define TM_LOAD		2
#define TM_TRIG		3
#define TM_REMK		4
#define TM_INS		5

#define TMM_MIN		(1<<TM_MIN)
#define TMM_WMAN	(1<<TM_WMAN)
#define TMM_LOAD	(1<<TM_LOAD)
#define TMM_TRIG	(1<<TM_TRIG)
#define TMM_REMK	(1<<TM_REMK)
#define TMM_INS		(1<<TM_INS)

	XL_SEXP *		query;
	char			query_mode;
	char			load_mode;
	int			remake_req;

	SYS_QUEUE		load_to_beam;
	SYS_QUEUE		beam_to_resource;
	SYS_QUEUE		resource_to_insert;

	REAL1			first_max;
	GB_RECT			first_r;

	char			win_manage_task_wp;
	char			win_manage_task_req;
	char			loading_task_wp;
	char			loading_task_req;
	char			min_route_task_wp;
	char			min_route_task_req;
	char			retrieve_task_wp;

	struct radar_cache *	next;
} RADAR_CACHE;

typedef struct radar_matrix_list {
	struct radar_matrix_list *	next;
	RADAR_MATRIX *			mx;
} RADAR_MATRIX_LIST;

typedef struct crd_list {
	RADAR_CACHE *		rc_ptr;
	WF_ID			wfid;
	RADAR_CRD *		crd;
	int			sts;
#define CLS_NONE		0
#define CLS_KEEP		1
#define CLS_REMOVE		2
#define CLS_INSERT		3
} CRD_LIST;

typedef struct beam_query {
	RADAR_LUMP *		target_rl;
	L_CHAR *		base_url;
	int			aboat;
	GB_RECT			rect;
	REAL1			min;
	REAL1			max;
	XL_SEXP *		query;

	XL_SEXP *		result;
} BEAM_QUERY;

typedef struct t_retrieve {
	Q_HEADER		h;
	L_CHAR *		crd;
	L_CHAR *		obj;
	LUMP_ROUTE *		lr;
	RADAR_CACHE *		rc_ptr;
} T_RETRIEVE;


XL_SEXP *
virtual_lump(
	GB_RECT * rect,
	REAL1	reso_min,
	REAL1	reso_max,
	XL_SEXP * query);
XL_SEXP * radar_query_regulation(XL_SEXP *);

typedef struct heuristics_param {
	int		ses;
	REAL1		base_resolution;
} HEURISTICS_PARAM;

#define CRT_LOADING_RES_RESOLVE	(CRT_MAX)

XL_SEXP * rc_insert_query(RADAR_CACHE * rc_ptr,XL_SEXP * query);
XL_SEXP * rc_set_query(RADAR_CACHE * rc_ptr,XL_SEXP * query);
XL_SEXP * rc_get_query(RADAR_CACHE * rc_ptr);
XL_SEXP * rc_delete_query(RADAR_CACHE * rc_ptr,int _no);
int rc_zoom(int ses,
	RADAR_CACHE * rc_ptr,
	RESOURCE * c,
	GB_RECT _r,
	REAL1 _rot);


#endif

