/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___RECORDLIST_H___
#define ___RECORDLIST_H___

#include	"pdb.h"


typedef struct chain_list {
	struct chain_list *	next;
	void *			ptr;
	int			len;
	int			free_flag;
} CHAIN_LIST;

typedef struct record_list {
	struct record_list *	next;
	PN_HEADER		header;
	unsigned int		fofs;
	void *			data;
	void *			ptr;
	int			body;
	CHAIN_LIST *		chain_head;
	CHAIN_LIST *		chain_tail;
} RECORD_LIST;


RECORD_LIST *
read_recordlist(int * sts,char * filename);
int write_recordlist(char * filename,RECORD_LIST * lst,int mode);
void set_recordlist_ptr(RECORD_LIST * lst,int body);
int check_recordlist_ptr(RECORD_LIST * lst);
void set_recordlist_chain(RECORD_LIST * lst,void * ptr,int len,int free_flag);
void free_recordlist(RECORD_LIST * lst);
RECORD_LIST * new_recordlist(unsigned short type,unsigned short size);

#define RLS_OK	0
#define RLS_CANNOT_OPEN	(-1)
#define RLS_READ_ERROR	(-2)
#define RLS_CORRUPT	(-3)

#endif

