/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl2pdb_p.h"

extern AVT_NODE * pdb_same_name_avt;
extern PDB_POLYGON2D * pdb_p_list;
CODE_INDEX * code_index;
unsigned int code_max;

typedef struct num_tree_work {
	AVT_NODE *		tree;
	unsigned int		code;
} NUM_TREE_WORK;

int
cmp_num(PDB_POLYGON2D * p1,PDB_POLYGON2D * p2)
{
PDB_POLYGON2D * max1, * max2;
	max1 = 0;
	max2 = 0;	

	for ( ; p1 ; p1 = p1->samename ) {
		if ( max1 == 0 || max1->seq < p1->seq )
			max1 = p1;
	}
	for ( ; p2 ; p2 = p2->samename ) {
		if ( max2 == 0 || max2->seq < p2->seq )
			max2 = p2;
	}
	if ( max1->seq < max2->seq )
		return -1;
	if ( max1->seq > max2->seq )
		return 1;
	return 0;
}

int
numbering_func1(AVT_NODE * a,NUM_TREE_WORK * w)
{
PDB_POLYGON2D * p, * max;
AVT_NODE * aa;

	aa = d_alloc(sizeof(*aa));
	aa->data = a->data;
	p = aa->data;

	avt_insert(&w->tree,aa,cmp_num);

	return 0;
}

int
t_func(AVT_NODE * a,void * w)
{
PDB_POLYGON2D * p;
	p = a->data;
	fflush(stdout);
	ss_printf("* %ls\n",p->name);
	return 0;
}

void
test_pdb()
{
	avt_trace_from_small(pdb_same_name_avt,t_func,0);
}

int
numbering_func2(AVT_NODE * a,NUM_TREE_WORK * w)
{
PDB_POLYGON2D * p, * pp, * min;
unsigned int code;
	pp = a->data;
	for ( p = pp ; p ; p = p->samename )
		p->code = 0;
	code = w->code;
	for ( ; ; ) {
		min = 0;
		for ( p = pp ; p ; p = p->samename ) {
			if ( p->code )
				continue;
			if ( min == 0 || min->seq > p->seq )
				min = p;
		}
		if ( min == 0 )
			break;
		min->code = code ++;
	}
	w->code += NO_PITCH;
	return 0;
}


void
free_num_tree(NUM_TREE_WORK * w)
{
AVT_NODE * a;
	for ( ; w->tree ; ) {
		a = avt_delete(&w->tree,w->tree->data,cmp_num);
		d_f_ree(a);
	}
}

void
set_black(PDB_POLYGON2D * p)
{
	p->line.r = p->line.g = p->line.b = 0;
	p->line.t = 1;
/*
	p->padding.t = 0;
*/
}

void
numbering()
{
PDB_POLYGON2D * p;
unsigned int i;
NUM_TREE_WORK w;
	w.tree = 0;
	avt_trace_from_small(pdb_same_name_avt,numbering_func1,&w);
	w.code = NO_PITCH;
	avt_trace_from_small(w.tree,numbering_func2,&w);
	free_num_tree(&w);

	for ( p = pdb_p_list ; p ; p = p->next )
		if ( p->code == 0 )
			er_panic("numbering(1)");


	code_max = w.code/NO_PITCH;
	code_index = d_alloc(sizeof(CODE_INDEX)*code_max);
	for ( i = 0 ; i < code_max ; i ++ ){
		code_index[i].fofs = -1;
		code_index[i].minrect.tl.x = code_index[i].minrect.tl.y = 0;
		code_index[i].minrect.br.x = code_index[i].minrect.br.y = -1;
	}
	ss_printf("\tmax id %i\n",code_max);
}
