/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_IfDef();


void
init_IfDef(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"IfDef"),
		get_func_prim(xl_IfDef,FO_NORMAL,0,3,3));
}

XL_SEXP *
xl_IfDef(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * sym;
XL_SEXP * ret;
 	sym = get_el(s,1);
	if ( get_type(sym) != XLT_SYMBOL )
		goto type_missmatch;
	ret = eval(env,sym);
	if ( get_type(ret) == XLT_ERROR )
		return eval(env,get_el(s,2));
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"IfDef"),
		0);
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"IfDef"),
		n_get_string("shell IfDefments initializing is required"));
}


