<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
<xsl:output method="xml" version='1.0' encoding="utf-8" indent='yes'/> 


<xsl:template match="/"> 
	<html>
		<head>
			<title>施設詳細情報</title>
		</head>
		<body>
			<xsl:apply-templates select="Sisetu" />
		</body>
	</html>
</xsl:template> 

<xsl:template match="Sisetu">
<div>
	<!-- 施設名称の表示 -->
	<div style="width:220px; font-size:90%">
		<b><xsl:value-of select="Name" /></b><br />
		<!-- ページリンクの表示(ラベルが定義されている場合) -->
		<xsl:variable name = "UrlLabel" select = "Data/Content/Link/label" />
		<xsl:if test = "$UrlLabel != ''">
			<xsl:variable name = "UrlLink" select = "Data/Content/Link/text" />
			<xsl:if test = "$UrlLink != ''">
				<a>
					<xsl:attribute name = "href">		
						<xsl:value-of select = "Data/Content/Link/text" />
					</xsl:attribute>
					<xsl:attribute name="target">_blank</xsl:attribute>
					<xsl:value-of select = "Data/Content/Link/label" />
				</a>
			</xsl:if>
		</xsl:if>
	</div>

	<div style="width:240px; height:100px; overflow:auto; font-size:90%">	
	<!-- 施設概要の表示(ラベルが定義されている場合) -->
		<xsl:variable name = "InfoLabel" select = "Data/Content/Info/label" />
		<xsl:if test = "$InfoLabel != ''">
			<b><xsl:value-of select="Data/Content/Info/label" />:</b><xsl:value-of select="Data/Content/Info/text" /><br />
		</xsl:if>

		<!-- 住所の表示(ラベルが定義されている場合) -->
		<xsl:variable name = "AddressLabel" select = "Data/Content/Address/label" />
		<xsl:if test = "$AddressLabel != ''">
			<b><xsl:value-of select="Data/Content/Address/label" />:</b><xsl:value-of select="Data/Content/Address/text" /><br />
		</xsl:if>

		<!-- 電話番号の表示(ラベルが定義されている場合) -->
		<xsl:variable name = "TelLabel" select = "Data/Content/Tel/label" />
		<xsl:if test = "$TelLabel != ''">
			<b><xsl:value-of select="Data/Content/Tel/label" />:</b><xsl:value-of select="Data/Content/Tel/text" /><br />
		</xsl:if>

		<!-- 写真の表示(ラベルが定義されている場合) -->
		<xsl:variable name = "PictLabel" select = "Data/Content/Pict/label" />
		<xsl:if test = "$PictLabel != ''">	
			<img>
				<xsl:attribute name = "src">
					<xsl:value-of select = "Data/Content/Pict/text" />
				</xsl:attribute>
				<xsl:attribute name = "width">		
					<xsl:value-of select = "120" />
				</xsl:attribute>
				<xsl:attribute name = "height">		
					<xsl:value-of select = "90" />
				</xsl:attribute>
				<xsl:attribute name = "alt">		
					<xsl:value-of select = "Data/Content/Pict/label" />
				</xsl:attribute>
			</img><br />
		</xsl:if>
	</div>
</div>	
</xsl:template>


</xsl:stylesheet>