/* $Id: alphablend.c,v 1.1.1.1 2002/09/17 04:53:12 iiojun Exp $ */

/* Face Pointer Library
 * Copyright (C) 1999-2002 Kazuo HIYANE, Jun IIO, and Tomoyuki YATABE
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "alphablend.h"

/* private function prototypes **************************************/
static void alphablend_write_frame_data (AlphaBlend* filter,
					 MalibFrame* frame);

/* virtual function table *******************************************/
static AlphaBlendClass alphablend_class = 
{
  (void (*)(MalibObject*)) 	     	 malib_merger_delete,
  (void (*)(MalibSource*, MalibFrame*))  alphablend_write_frame_data
};

/* public functions **************************************************/
AlphaBlend*
alphablend_new ()
{
  AlphaBlend* retptr;
  MALIB_FILTER_GENERIC_NEW_0 ( AlphaBlend, &alphablend_class,
			       MALIB_FRAME_COLORMODEL_RGB, &retptr );

  /* set the buffer information for subwindow */
  malib_merger_alloc_bufinfo_table ((MalibMerger*)retptr, 1);
  malib_merger_set_acceptable ((MalibMerger*)retptr, 0, 
			       MALIB_FRAME_COLORMODEL_RGB_A);

  return retptr;
}

AlphaBlend*
alphablend_new_with_bufs (MalibBuffer* buf0, MalibBuffer* buf1)
{
  AlphaBlend* retptr;
  MalibBuffer* buffers[3];

  g_return_if_fail (buf0 && buf1);

  /* check the frame size of two buffers */
  /* currently it is not supported to mix the buffers 
     which have different size each other */
  /*
  if ( malib_frame_get_image_size (malib_buffer_get_current_frame (buf0))
       != malib_frame_get_image_size (malib_buffer_get_current_frame (buf1)) )
    {
      g_error ("Sorry, mixing different size frames is currently not supported.");
    }
  */

  retptr = alphablend_new ();

  /* set the pairs of buffer and acceptable information */
  buffers[0] = buf0;
  buffers[1] = buf1;
  buffers[2] = NULL;
  malib_merger_set_buffers ((MalibMerger*)retptr, buffers);

  return retptr;
}

/* private functions *************************************************/
static void
alphablend_write_frame_data (AlphaBlend* filter, MalibFrame* frame)
{
  MalibBuffer* input[2];
  unsigned int i, j, image_size, maxval, alpha;

  /* the flag whether we need to propagate previous section */
  int need_increment = 0;
  
  /* pointers to previous frame data and data area to store 
     the result of calculation */
  int* from0;  /* RGB */
  int* from1;  /* RGB_A */
  int* to;

  g_return_if_fail (filter && frame);
  g_return_if_fail (((MalibFilter*)filter)->buf && frame->data);

  input[0] = ((MalibFilter*)filter)->buf;
  input[1] = ((MalibMerger*)filter)->bufinfo_tbl->buf;
  to    = frame->data;

  /* increment previous buffer data */
  MALIB_OBJECT_COUNT_REFERENCES (filter, need_increment);

  if (need_increment)
    {
      malib_holder_increment_frame ((MalibHolder*)input[0]);
      malib_holder_increment_frame ((MalibHolder*)input[1]);
    }

  /* get pointers to previous frame data */
  from0 = malib_buffer_get_current_frame (input[0]) ->data;
  from1 = malib_buffer_get_current_frame (input[1]) ->data;

  maxval = (1 << MALIB_FRAME_DEFAULT_DEPTH_RGB) - 1;

  image_size = malib_filter_calc_output_image_size ((MalibFilter*) filter);

  /* create mixed image */
  for (i = 0; i < image_size; i += MALIB_FRAME_DEFAULT_NUM_COLORS_RGB)
    {
      alpha = from1 [MALIB_FRAME_DEFAULT_NUM_COLORS_RGB];
      for (j = 0; j < MALIB_FRAME_DEFAULT_NUM_COLORS_RGB; j++)
	{
	  to[i + j] = ((maxval - alpha) * (*from0++) 
		       + alpha * (*from1++)) / maxval;
	}
      from1 ++;
    }
}

