/* $Id: face_region.h,v 1.1.1.1 2002/09/17 04:53:12 iiojun Exp $ */

/* Face Pointer Library
 * Copyright (C) 1999-2002 Kazuo HIYANE, Jun IIO, and Tomoyuki YATABE
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FACE_REGION_H__
#define __FACE_REGION_H__

#include <malib/malib_common.h>

BEGIN_C_DECLS

typedef struct _FaceRegion FaceRegion;
typedef struct _FaceRegionClass FaceRegionClass;

typedef struct _FaceRectangle FaceRectangle;

#include <malib/filter.h>

/* BLOCKSIZE must be common factor of width and height */
#define FACE_REGION_BLOCKSIZE 		2
#define FACE_REGION_BLOB_THRESHOLD 	1000

/* mask size is (2 * MASK_OFFSET + 1)^2 */
#define FACE_REGION_MASK_OFFSET 	1
#define FACE_REGION_THRESHOLD		0.3

/* face pixel definition by oval */
#define FACE_REGION_DEFAULT_ALPHA_MEAN	0.58
#define FACE_REGION_DEFAULT_BETA_MEAN	0.34
#define FACE_REGION_ALPHA_COEF		0.06
#define FACE_REGION_BETA_COEF		0.08

/* display method control */
//#define FACE_REGION_DISPLAY_BOUNDINGBOX
//#define FACE_REGION_SHADE_INPUTIMAGE
#define FACE_REGION_HIDE_INPUTIMAGE

// #define FACE_REGION_ANTI_ALIASING

struct _FaceRectangle
{
  int			min_x, min_y, max_x, max_y;
};

struct _FaceRegion
{
  MalibFilter		super;

  /* candidate grid and region masks */
  int*			score;
  int*			mask;

  /* for calculating face region... */
  int 			width, height;
  int 			column, row;
  FaceRectangle		closure;

  /* for discriminating face pixels... */
  double		a_mean, b_mean;
  double		a_coef, b_coef;
};

struct _FaceRegionClass
{
  MalibFilterClass	super;
};

FaceRegion*  face_region_new ();
FaceRegion*  face_region_new_with_buf (MalibBuffer* buf);

void	 face_region_set_color_params (FaceRegion* filter,
				       double a_mean, double b_mean,
				       double a_coef, double b_coef);

void	 face_region_get_color_params (FaceRegion* filter,
				       double* a_mean, double* b_mean,
				       double* a_coef, double* b_coef);

END_C_DECLS

#endif /* __FACEREGION_H__ */
