/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;

class GroupedResult {
    private Result result;
    int groupBegin;
    int groupEnd;
    private final boolean isGrouped;
    private final boolean isAggregated;
    private HashSet groups;
    private ResultGroup currGroup;

    GroupedResult(Select select, Result.ResultMetaData resultMetaData) {
        this.result = new Result(resultMetaData);
        this.groupBegin = select.iResultLen;
        this.groupEnd = this.groupBegin + select.iGroupLen;
        this.isGrouped = this.groupBegin != this.groupEnd;
        this.isAggregated = select.isAggregated;
        if (this.isGrouped) {
            this.groups = new HashSet();
        }
    }

    Object[] getRow(Object[] objectArray) {
        if (this.isGrouped) {
            ResultGroup resultGroup = new ResultGroup(objectArray);
            ResultGroup resultGroup2 = (ResultGroup)this.groups.get(resultGroup);
            if (resultGroup2 != null) {
                ArrayUtil.copyArray(resultGroup2.row, objectArray, objectArray.length);
            }
        } else if (this.isAggregated && this.currGroup != null) {
            ArrayUtil.copyArray(this.currGroup.row, objectArray, objectArray.length);
        }
        return objectArray;
    }

    void addRow(Object[] objectArray) {
        if (this.isGrouped) {
            ResultGroup resultGroup = new ResultGroup(objectArray);
            this.currGroup = (ResultGroup)this.groups.get(resultGroup);
            if (this.currGroup == null) {
                this.currGroup = resultGroup;
                this.groups.add(this.currGroup);
                this.result.add(objectArray);
            } else {
                ArrayUtil.copyArray(objectArray, this.currGroup.row, objectArray.length);
            }
        } else if (this.isAggregated) {
            if (this.currGroup == null) {
                this.currGroup = new ResultGroup(objectArray);
                this.result.add(objectArray);
            } else {
                ArrayUtil.copyArray(objectArray, this.currGroup.row, objectArray.length);
            }
        } else {
            this.result.add(objectArray);
        }
    }

    int size() {
        return this.result.getSize();
    }

    Iterator iterator() {
        return this.result.iterator();
    }

    Result getResult() {
        return this.result;
    }

    class ResultGroup {
        Object[] row;
        int hashCode;

        private ResultGroup(Object[] objectArray) {
            this.row = objectArray;
            this.hashCode = 0;
            for (int i = GroupedResult.this.groupBegin; i < GroupedResult.this.groupEnd; ++i) {
                if (objectArray[i] == null) continue;
                this.hashCode += objectArray[i].hashCode();
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !(object instanceof ResultGroup)) {
                return false;
            }
            ResultGroup resultGroup = (ResultGroup)object;
            for (int i = GroupedResult.this.groupBegin; i < GroupedResult.this.groupEnd; ++i) {
                if (this.equals(this.row[i], resultGroup.row[i])) continue;
                return false;
            }
            return true;
        }

        private boolean equals(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }
}

