/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import javax.naming.NamingException;
import org.springframework.jndi.JndiAccessor;

public abstract class JndiLocatorSupport
extends JndiAccessor {
    public static final String CONTAINER_PREFIX = "java:comp/env/";
    private boolean resourceRef = false;

    public void setResourceRef(boolean resourceRef) {
        this.resourceRef = resourceRef;
    }

    public boolean isResourceRef() {
        return this.resourceRef;
    }

    protected Object lookup(String jndiName) throws NamingException {
        return this.lookup(jndiName, null);
    }

    protected Object lookup(String jndiName, Class requiredType) throws NamingException {
        String jndiNameToUse = this.convertJndiName(jndiName);
        Object jndiObject = this.getJndiTemplate().lookup(jndiNameToUse, requiredType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Located object with JNDI name [" + jndiNameToUse + "]"));
        }
        return jndiObject;
    }

    protected String convertJndiName(String jndiName) {
        if (this.isResourceRef() && !jndiName.startsWith(CONTAINER_PREFIX) && jndiName.indexOf(58) == -1) {
            jndiName = CONTAINER_PREFIX + jndiName;
        }
        return jndiName;
    }
}

