/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.coerce;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.ConstructorUtils;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.coerce.CoerceMessages;
import org.apache.tapestry.coerce.TypeConverter;
import org.apache.tapestry.coerce.TypeConverterContribution;
import org.apache.tapestry.coerce.ValueConverter;

public class ValueConverterImpl
implements ValueConverter {
    private Map _converterMap = new HashMap();
    public List _contributions;
    private Map _primitiveToWrapper = new HashMap();
    private Map _wrapperToPrimitive = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public ValueConverterImpl() {
        this.store(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ValueConverterImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.store(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = ValueConverterImpl.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.store(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = ValueConverterImpl.class$("java.lang.Short")) : class$java$lang$Short);
        this.store(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = ValueConverterImpl.class$("java.lang.Character")) : class$java$lang$Character);
        this.store(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = ValueConverterImpl.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.store(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = ValueConverterImpl.class$("java.lang.Long")) : class$java$lang$Long);
        this.store(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = ValueConverterImpl.class$("java.lang.Float")) : class$java$lang$Float);
        this.store(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = ValueConverterImpl.class$("java.lang.Double")) : class$java$lang$Double);
    }

    private void store(Class primitive, Class wrapper) {
        this._primitiveToWrapper.put(primitive, wrapper);
        this._wrapperToPrimitive.put(wrapper, primitive);
    }

    public void initializeService() {
        Iterator i = this._contributions.iterator();
        while (i.hasNext()) {
            TypeConverterContribution c = (TypeConverterContribution)i.next();
            this._converterMap.put(c.getSubjectClass(), c.getConverter());
        }
    }

    public Object coerceValue(Object value, Class desiredType) {
        Defense.notNull((Object)desiredType, (String)"desiredType");
        Class effectiveType = this.convertType(desiredType);
        if (value != null && effectiveType.isAssignableFrom(value.getClass())) {
            return value;
        }
        Number result = this.convertNumberToNumber(value, effectiveType);
        if (result != null) {
            return result;
        }
        result = this.convertUsingPropertyEditor(value, effectiveType);
        if (result != null) {
            return result;
        }
        TypeConverter converter = (TypeConverter)this._converterMap.get(effectiveType);
        if (value == null && converter == null) {
            return null;
        }
        if (converter == null) {
            throw new ApplicationRuntimeException(CoerceMessages.noConverter(effectiveType));
        }
        return converter.convertValue(value);
    }

    private Number convertUsingPropertyEditor(Object value, Class targetType) {
        if (value == null || value.getClass() != (class$java$lang$String == null ? (class$java$lang$String = ValueConverterImpl.class$("java.lang.String")) : class$java$lang$String) || !(class$java$lang$Number == null ? (class$java$lang$Number = ValueConverterImpl.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(targetType)) {
            return null;
        }
        Class primitiveType = (Class)this._wrapperToPrimitive.get(targetType);
        if (primitiveType == null) {
            return null;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(primitiveType);
        if (editor == null) {
            return null;
        }
        String text = (String)value;
        try {
            editor.setAsText(text);
            return (Number)editor.getValue();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(CoerceMessages.stringToNumberConversionError(text, targetType, ex), (Throwable)ex);
        }
    }

    private Number convertNumberToNumber(Object value, Class targetType) {
        if (value == null || !(class$java$lang$Number == null ? (class$java$lang$Number = ValueConverterImpl.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(value.getClass()) || !(class$java$lang$Number == null ? (class$java$lang$Number = ValueConverterImpl.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(targetType)) {
            return null;
        }
        String valueAsString = value.toString();
        return (Number)ConstructorUtils.invokeConstructor((Class)targetType, (Object[])new Object[]{valueAsString});
    }

    private Class convertType(Class possiblePrimitiveType) {
        Class wrapperType = (Class)this._primitiveToWrapper.get(possiblePrimitiveType);
        return wrapperType == null ? possiblePrimitiveType : wrapperType;
    }

    public void setContributions(List contributions) {
        this._contributions = contributions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

