/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import org.apache.tapestry.form.IPropertySelectionModel;

public class LabeledPropertySelectionModel
implements IPropertySelectionModel {
    private IPropertySelectionModel _model;
    private String _label = "";
    private Object _option = null;
    private String _value = "";
    private static final IPropertySelectionModel EMPTY_MODEL = new IPropertySelectionModel(){

        public int getOptionCount() {
            return 0;
        }

        public Object getOption(int index) {
            return null;
        }

        public String getLabel(int index) {
            return null;
        }

        public String getValue(int index) {
            return null;
        }

        public Object translateValue(String value) {
            return null;
        }
    };

    public LabeledPropertySelectionModel() {
        this(EMPTY_MODEL);
    }

    public LabeledPropertySelectionModel(IPropertySelectionModel model) {
        this._model = model;
    }

    public LabeledPropertySelectionModel(IPropertySelectionModel model, String label) {
        this(model);
        this._label = label;
    }

    public LabeledPropertySelectionModel(IPropertySelectionModel model, String label, Object option) {
        this(model, label);
        this._option = option;
    }

    public LabeledPropertySelectionModel(IPropertySelectionModel model, String label, Object option, String value) {
        this(model, label, option);
        this._value = value;
    }

    public IPropertySelectionModel getModel() {
        return this._model;
    }

    public void setModel(IPropertySelectionModel model) {
        this._model = model;
    }

    public int getOptionCount() {
        return this._model.getOptionCount() + 1;
    }

    public Object getOption(int index) {
        return index == 0 ? this._option : this._model.getOption(index - 1);
    }

    public String getLabel(int index) {
        return index == 0 ? this._label : this._model.getLabel(index - 1);
    }

    public String getValue(int index) {
        return index == 0 ? this._value : this._model.getValue(index - 1);
    }

    public Object translateValue(String value) {
        if (value == null) {
            return null;
        }
        return value.equals(this._value) ? this._option : this._model.translateValue(value);
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public Object getOption() {
        return this._option;
    }

    public void setOption(Object option) {
        this._option = option;
    }
}

