/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.pageload;

import java.util.Iterator;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.binding.BindingSource;
import org.apache.tapestry.pageload.IComponentVisitor;
import org.apache.tapestry.pageload.PageloadMessages;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IParameterSpecification;

public class EstablishDefaultParameterValuesVisitor
implements IComponentVisitor {
    private BindingSource _bindingSource;

    public void visitComponent(IComponent component) {
        IComponentSpecification spec = component.getSpecification();
        Iterator i = spec.getParameterNames().iterator();
        while (i.hasNext()) {
            String defaultValue;
            IParameterSpecification parameterSpec;
            String name = (String)i.next();
            if (!name.equals((parameterSpec = spec.getParameter(name)).getParameterName()) || (defaultValue = parameterSpec.getDefaultValue()) == null) continue;
            if (parameterSpec.isRequired()) {
                throw new ApplicationRuntimeException(PageloadMessages.parameterMustHaveNoDefaultValue(component, name), (Object)component, parameterSpec.getLocation(), null);
            }
            if (component.getBinding(name) != null) continue;
            String description = PageloadMessages.defaultParameterName(name);
            IBinding binding = this._bindingSource.createBinding(component, description, defaultValue, "ognl", parameterSpec.getLocation());
            component.setBinding(name, binding);
        }
    }

    public void setBindingSource(BindingSource bindingSource) {
        this._bindingSource = bindingSource;
    }
}

