/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.resolver;

import org.apache.hivemind.Resource;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.engine.ISpecificationSource;
import org.apache.tapestry.resolver.ISpecificationResolverDelegate;
import org.apache.tapestry.spec.IComponentSpecification;

public class AbstractSpecificationResolver {
    private INamespace _namespace;
    private IComponentSpecification _specification;
    private ISpecificationSource _specificationSource;
    private ISpecificationResolverDelegate _delegate;
    private String _applicationId;
    private Resource _contextRoot;
    private Resource _webInfLocation;
    private Resource _webInfAppLocation;

    public void initializeService() {
        this._webInfLocation = this._contextRoot.getRelativeResource("WEB-INF/");
        this._webInfAppLocation = this._webInfLocation.getRelativeResource(this._applicationId + "/");
    }

    public ISpecificationResolverDelegate getDelegate() {
        return this._delegate;
    }

    protected Resource getContextRoot() {
        return this._contextRoot;
    }

    public void setContextRoot(Resource contextRoot) {
        this._contextRoot = contextRoot;
    }

    protected void setNamespace(INamespace namespace) {
        this._namespace = namespace;
    }

    public INamespace getNamespace() {
        return this._namespace;
    }

    protected ISpecificationSource getSpecificationSource() {
        return this._specificationSource;
    }

    protected Resource getWebInfLocation() {
        return this._webInfLocation;
    }

    protected Resource getWebInfAppLocation() {
        return this._webInfAppLocation;
    }

    public IComponentSpecification getSpecification() {
        return this._specification;
    }

    protected void setSpecification(IComponentSpecification specification) {
        this._specification = specification;
    }

    protected void reset() {
        this._namespace = null;
        this._specification = null;
    }

    public void setDelegate(ISpecificationResolverDelegate delegate) {
        this._delegate = delegate;
    }

    public void setApplicationId(String applicationId) {
        this._applicationId = applicationId;
    }

    public void setSpecificationSource(ISpecificationSource source) {
        this._specificationSource = source;
    }

    protected INamespace getApplicationNamespace() {
        return this._specificationSource.getApplicationNamespace();
    }

    protected INamespace getFrameworkNamespace() {
        return this._specificationSource.getFrameworkNamespace();
    }

    protected INamespace findNamespaceForId(INamespace containerNamespace, String libraryId) {
        if (libraryId == null) {
            return containerNamespace;
        }
        if (libraryId.equals("application")) {
            return this.getApplicationNamespace();
        }
        if (libraryId.equals("framework")) {
            return this.getFrameworkNamespace();
        }
        return containerNamespace.getChildNamespace(libraryId);
    }
}

