/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.enhance.EnhancedClassValidator;
import org.apache.tapestry.enhance.EnhancementOperationImpl;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.event.ReportStatusEvent;
import org.apache.tapestry.event.ReportStatusListener;
import org.apache.tapestry.event.ResetEventListener;
import org.apache.tapestry.services.ComponentConstructor;
import org.apache.tapestry.services.ComponentConstructorFactory;
import org.apache.tapestry.spec.IComponentSpecification;

public class ComponentConstructorFactoryImpl
implements ComponentConstructorFactory,
ResetEventListener,
ReportStatusListener {
    private String _serviceId;
    private Log _log;
    private ClassFactory _classFactory;
    private ClassResolver _classResolver;
    private EnhancedClassValidator _validator;
    private EnhancementWorker _chain;
    private Map _cachedConstructors = Collections.synchronizedMap(new HashMap());

    public void resetEventDidOccur() {
        this._cachedConstructors.clear();
    }

    public synchronized void reportStatus(ReportStatusEvent event) {
        event.title(this._serviceId);
        event.property("enhanced class count", this._cachedConstructors.size());
        event.collection("enhanced classes", this._cachedConstructors.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentConstructor getComponentConstructor(IComponentSpecification specification, String className) {
        Defense.notNull((Object)specification, (String)"specification");
        IComponentSpecification iComponentSpecification = specification;
        synchronized (iComponentSpecification) {
            ComponentConstructor result = (ComponentConstructor)this._cachedConstructors.get(specification);
            if (result == null) {
                Class baseClass = this._classResolver.findClass(className);
                EnhancementOperationImpl eo = new EnhancementOperationImpl(this._classResolver, specification, baseClass, this._classFactory, this._log);
                this._chain.performEnhancement(eo, specification);
                result = eo.getConstructor();
                this._validator.validate(baseClass, result.getComponentClass(), specification);
                this._cachedConstructors.put(specification, result);
            }
            return result;
        }
    }

    public void setClassFactory(ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    public void setClassResolver(ClassResolver classResolver) {
        this._classResolver = classResolver;
    }

    public void setValidator(EnhancedClassValidator validator) {
        this._validator = validator;
    }

    public void setChain(EnhancementWorker chain) {
        this._chain = chain;
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public void setServiceId(String serviceId) {
        this._serviceId = serviceId;
    }
}

