/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.HashMap;
import java.util.Map;
import ognl.Ognl;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.event.ReportStatusEvent;
import org.apache.tapestry.event.ReportStatusListener;
import org.apache.tapestry.event.ResetEventListener;
import org.apache.tapestry.services.ExpressionCache;
import org.apache.tapestry.services.impl.ImplMessages;

public class ExpressionCacheImpl
implements ExpressionCache,
ResetEventListener,
ReportStatusListener {
    private String _serviceId;
    private Map _cache = new HashMap();

    public synchronized void resetEventDidOccur() {
        this._cache.clear();
    }

    public void reportStatus(ReportStatusEvent event) {
        event.title(this._serviceId);
        event.property("cached expression count", this._cache.size());
        event.collection("cached expressions", this._cache.keySet());
    }

    public synchronized Object getCompiledExpression(String expression) {
        Object result = this._cache.get(expression);
        if (result == null) {
            result = this.parse(expression);
            this._cache.put(expression, result);
        }
        return result;
    }

    private Object parse(String expression) {
        try {
            return Ognl.parseExpression((String)expression);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToParseExpression(expression, ex), (Throwable)ex);
        }
    }

    public void setServiceId(String serviceId) {
        this._serviceId = serviceId;
    }
}

