/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.hivemind.service.ThreadLocale;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.services.CookieSource;
import org.apache.tapestry.services.RequestLocaleManager;
import org.apache.tapestry.web.WebRequest;

public class RequestLocaleManagerImpl
implements RequestLocaleManager {
    private WebRequest _request;
    private Locale _requestLocale;
    private CookieSource _cookieSource;
    private ThreadLocale _threadLocale;
    private String _acceptedLocales;
    private Locale _defaultLocale;
    private Set _acceptedLocaleNamesSet = new HashSet();
    private Map _localeCache = new HashMap();

    public void initializeService() {
        String[] names = TapestryUtils.split(this._acceptedLocales);
        if (names.length == 0) {
            return;
        }
        this._defaultLocale = this.getLocale(names[0]);
        this._acceptedLocaleNamesSet.addAll(Arrays.asList(names));
    }

    public Locale extractLocaleForCurrentRequest() {
        String localeName = this._cookieSource.readCookieValue("org.apache.tapestry.locale");
        String requestedLocale = localeName != null ? localeName : this._request.getLocale().toString();
        this._requestLocale = this.filterRequestedLocale(requestedLocale);
        this._threadLocale.setLocale(this._requestLocale);
        return this._requestLocale;
    }

    Locale filterRequestedLocale(String localeName) {
        if (this._acceptedLocaleNamesSet.isEmpty()) {
            return this.getLocale(localeName);
        }
        do {
            if (!this._acceptedLocaleNamesSet.contains(localeName)) continue;
            return this.getLocale(localeName);
        } while ((localeName = this.stripTerm(localeName)).length() != 0);
        return this._defaultLocale;
    }

    private String stripTerm(String localeName) {
        int scorex = localeName.lastIndexOf(95);
        return scorex < 0 ? "" : localeName.substring(0, scorex);
    }

    public void persistLocale() {
        Locale locale = this._threadLocale.getLocale();
        if (locale.equals(this._requestLocale)) {
            return;
        }
        this._cookieSource.writeCookieValue("org.apache.tapestry.locale", locale.toString());
    }

    Locale getLocale(String name) {
        Locale result = (Locale)this._localeCache.get(name);
        if (result == null) {
            result = this.constructLocale(name);
            this._localeCache.put(name, result);
        }
        return result;
    }

    private Locale constructLocale(String name) {
        String[] terms = TapestryUtils.split(name, '_');
        switch (terms.length) {
            case 1: {
                return new Locale(terms[0], "");
            }
            case 2: {
                return new Locale(terms[0], terms[1]);
            }
            case 3: {
                return new Locale(terms[0], terms[1], terms[2]);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setCookieSource(CookieSource source) {
        this._cookieSource = source;
    }

    public void setRequest(WebRequest request) {
        this._request = request;
    }

    public void setThreadLocale(ThreadLocale threadLocale) {
        this._threadLocale = threadLocale;
    }

    public void setAcceptedLocales(String acceptedLocales) {
        this._acceptedLocales = acceptedLocales;
    }
}

