/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.components.IPrimaryKeyConverter;
import org.apache.tapestry.util.UtilMessages;

public class DefaultPrimaryKeyConverter
implements IPrimaryKeyConverter {
    private final Map _map = new HashMap();
    private final List _keys = new ArrayList();
    private final List _values = new ArrayList();
    private Object _lastValue;
    private Set _deletedValues;

    public void clear() {
        this._map.clear();
        this._keys.clear();
        this._values.clear();
        this._lastValue = null;
        this._deletedValues = null;
    }

    public final void add(Object key, Object value) {
        Defense.notNull((Object)key, (String)"key");
        Defense.notNull((Object)value, (String)"value");
        if (this._map.containsKey(key)) {
            throw new ApplicationRuntimeException(UtilMessages.keyAlreadyExists(key));
        }
        this._map.put(key, value);
        this._keys.add(key);
        this._values.add(value);
        this._lastValue = value;
    }

    public final List getAllValues() {
        return Collections.unmodifiableList(this._values);
    }

    public final List getValues() {
        if (this.isDeletedValuesEmpty()) {
            return this.getAllValues();
        }
        ArrayList result = new ArrayList(this._values);
        result.removeAll(this._deletedValues);
        return result;
    }

    private boolean isDeletedValuesEmpty() {
        return this._deletedValues == null || this._deletedValues.isEmpty();
    }

    public final boolean isDeleted() {
        return this.checkValueSetForLastValue(this._deletedValues);
    }

    protected final boolean checkValueSetForLastValue(Set valueSet) {
        return valueSet != null && valueSet.contains(this._lastValue);
    }

    public final void setDeleted(boolean deleted) {
        this._deletedValues = this.updateValueSetForLastValue(this._deletedValues, deleted);
    }

    protected final Set updateValueSetForLastValue(Set set, boolean inSet) {
        if (inSet) {
            if (set == null) {
                set = new HashSet<Object>();
            }
            set.add(this._lastValue);
            return set;
        }
        if (set != null) {
            set.remove(this._lastValue);
        }
        return set;
    }

    public final Object getLastValue() {
        return this._lastValue;
    }

    public final Set getDeletedValues() {
        return this.createUnmodifiableSet(this._deletedValues);
    }

    protected final Set createUnmodifiableSet(Set valueSet) {
        return valueSet == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(valueSet);
    }

    public final void removeDeletedValues() {
        this._lastValue = null;
        if (this.isDeletedValuesEmpty()) {
            return;
        }
        int count = this._keys.size();
        for (int i = count - 1; i >= 0; --i) {
            if (!this._deletedValues.contains(this._values.get(i))) continue;
            this._values.remove(i);
            Object key = this._keys.remove(i);
            this._map.remove(key);
        }
    }

    public final Object getPrimaryKey(Object value) {
        int index = this._values.indexOf(value);
        if (index < 0) {
            throw new ApplicationRuntimeException(UtilMessages.valueNotFound(value), value, null, null);
        }
        this._lastValue = value;
        return this._keys.get(index);
    }

    public final Object getValue(Object primaryKey) {
        Object result = this._map.get(primaryKey);
        if (result == null) {
            result = this.provideMissingValue(primaryKey);
        }
        this._lastValue = result;
        return result;
    }

    protected Object provideMissingValue(Object key) {
        return null;
    }
}

