/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.tapestry.Tapestry;

public class MultiKey
implements Externalizable {
    private static final long serialVersionUID = 4465448607415788806L;
    private static final int HASH_CODE_UNSET = -1;
    private transient int hashCode = -1;
    private Object[] keys;

    public MultiKey() {
    }

    public MultiKey(Object[] keys, boolean makeCopy) {
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException(Tapestry.getMessage("MultiKey.null-keys"));
        }
        if (keys[0] == null) {
            throw new IllegalArgumentException(Tapestry.getMessage("MultiKey.first-element-may-not-be-null"));
        }
        if (makeCopy) {
            this.keys = new Object[keys.length];
            System.arraycopy(keys, 0, this.keys, 0, keys.length);
        } else {
            this.keys = keys;
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.keys == null) {
            throw new IllegalStateException(Tapestry.getMessage("MultiKey.no-keys"));
        }
        try {
            MultiKey otherMulti = (MultiKey)other;
            if (this.keys.length != otherMulti.keys.length) {
                return false;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == otherMulti.keys[i]) continue;
                if (this.keys[i] == null || otherMulti.keys[i] == null) {
                    return false;
                }
                if (this.keys[i].equals(otherMulti.keys[i])) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.keys[0].hashCode();
            for (int i = 1; i < this.keys.length; ++i) {
                if (this.keys[i] == null) continue;
                this.hashCode ^= this.keys[i].hashCode();
            }
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("MultiKey[");
        for (int i = 0; i < this.keys.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            if (this.keys[i] == null) {
                buffer.append("<null>");
                continue;
            }
            buffer.append(this.keys[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            out.writeObject(this.keys[i]);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int count = in.readInt();
        this.keys = new Object[count];
        for (int i = 0; i < count; ++i) {
            this.keys[i] = in.readObject();
        }
    }
}

