/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.tapestry.services.DataSqueezer;
import org.apache.tapestry.util.io.IoMessages;
import org.apache.tapestry.util.io.ResolvingObjectInputStream;
import org.apache.tapestry.util.io.SqueezeAdaptor;
import org.apache.tapestry.util.io.TeeOutputStream;

public class SerializableAdaptor
implements SqueezeAdaptor {
    private ClassResolver _resolver;
    private static final char BYTESTREAM_PREFIX = 'O';
    private static final char GZIP_BYTESTREAM_PREFIX = 'Z';
    private static final String PREFIX = "OZ";
    static /* synthetic */ Class class$java$io$Serializable;

    public String getPrefix() {
        return PREFIX;
    }

    public Class getDataClass() {
        return class$java$io$Serializable == null ? (class$java$io$Serializable = SerializableAdaptor.class$("java.io.Serializable")) : class$java$io$Serializable;
    }

    public String squeeze(DataSqueezer squeezer, Object data) {
        try {
            ByteArrayOutputStream bosPlain = new ByteArrayOutputStream();
            ByteArrayOutputStream bosCompressed = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(bosCompressed);
            TeeOutputStream tos = new TeeOutputStream(bosPlain, gos);
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(tos));
            oos.writeObject(data);
            oos.close();
            boolean useCompressed = bosCompressed.size() < bosPlain.size();
            byte[] byteArray = useCompressed ? bosCompressed.toByteArray() : bosPlain.toByteArray();
            byte[] encoded = Base64.encodeBase64((byte[])byteArray);
            String prefix = Character.toString(useCompressed ? (char)'Z' : 'O');
            return prefix + new String(encoded);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(IoMessages.encodeFailure(data, ex), (Throwable)ex);
        }
    }

    public Object unsqueeze(DataSqueezer squeezer, String encoded) {
        char prefix = encoded.charAt(0);
        try {
            byte[] mimeData = encoded.substring(1).getBytes();
            byte[] decoded = Base64.decodeBase64((byte[])mimeData);
            InputStream is = new ByteArrayInputStream(decoded);
            if (prefix == 'Z') {
                is = new GZIPInputStream(is);
            }
            is = new BufferedInputStream(is);
            ResolvingObjectInputStream ois = new ResolvingObjectInputStream(this._resolver, is);
            Object result = ois.readObject();
            ois.close();
            return result;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(IoMessages.decodeFailure(ex), (Throwable)ex);
        }
    }

    public void setResolver(ClassResolver resolver) {
        this._resolver = resolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

