/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.IValidator;
import org.apache.tapestry.valid.ValidatorException;

public abstract class ValidField
extends AbstractFormComponent {
    public abstract boolean isHidden();

    public abstract boolean isDisabled();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract String getDisplayName();

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IValidationDelegate delegate;
        delegate.registerForFocus(this, (delegate = this.getForm().getDelegate()).isInError() ? 3 : 1);
        delegate.writePrefix(writer, cycle, this, null);
        writer.beginEmpty("input");
        writer.attribute("type", this.isHidden() ? "password" : "text");
        if (this.isDisabled()) {
            writer.attribute("disabled", "disabled");
        }
        writer.attribute("name", this.getName());
        String value = this.readValue();
        if (value != null) {
            writer.attribute("value", value);
        }
        this.renderIdAttribute(writer, cycle);
        this.renderInformalParameters(writer, cycle);
        delegate.writeAttributes(writer, cycle, this, null);
        IValidator validator = this.getValidator();
        if (validator == null) {
            throw Tapestry.createRequiredParameterException(this, "validator");
        }
        if (validator.isRequired()) {
            delegate.registerForFocus(this, 2);
        }
        validator.renderValidatorContribution(this, writer, cycle);
        writer.closeTag();
        delegate.writeSuffix(writer, cycle, this, null);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String value = cycle.getParameter(this.getName());
        this.updateValue(value);
    }

    protected String readValue() {
        IValidator validator = this.getValidator();
        if (validator == null) {
            throw Tapestry.createRequiredParameterException(this, "validator");
        }
        IValidationDelegate delegate = this.getForm().getDelegate();
        if (delegate.isInError()) {
            return delegate.getFieldInputValue();
        }
        Object value = this.getValue();
        String result = validator.toString(this, value);
        return result;
    }

    protected void updateValue(String value) {
        Object objectValue = null;
        IValidator validator = this.getValidator();
        if (validator == null) {
            throw Tapestry.createRequiredParameterException(this, "validator");
        }
        IValidationDelegate delegate = this.getForm().getDelegate();
        delegate.recordFieldInputValue(value);
        try {
            objectValue = validator.toObject(this, value);
        }
        catch (ValidatorException ex) {
            delegate.record(ex);
            return;
        }
        this.setValue(objectValue);
    }

    public abstract IValidator getValidator();
}

