/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Principal;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.catalina.cluster.session.DeltaSession;
import org.apache.catalina.cluster.session.SerializablePrincipal;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeltaRequest
implements Externalizable {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$session$DeltaRequest == null ? (class$org$apache$catalina$cluster$session$DeltaRequest = DeltaRequest.class$("org.apache.catalina.cluster.session.DeltaRequest")) : class$org$apache$catalina$cluster$session$DeltaRequest));
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.session");
    public static final int TYPE_ATTRIBUTE = 0;
    public static final int TYPE_PRINCIPAL = 1;
    public static final int TYPE_ISNEW = 2;
    public static final int TYPE_MAXINTERVAL = 3;
    public static final int ACTION_SET = 0;
    public static final int ACTION_REMOVE = 1;
    public static final String NAME_PRINCIPAL = "__SET__PRINCIPAL__";
    public static final String NAME_MAXINTERVAL = "__SET__MAXINTERVAL__";
    public static final String NAME_ISNEW = "__SET__ISNEW__";
    private String sessionId;
    private LinkedList actions = new LinkedList();
    private LinkedList actionPool = new LinkedList();
    private boolean recordAllActions = false;
    static /* synthetic */ Class class$org$apache$catalina$cluster$session$DeltaRequest;

    public DeltaRequest() {
    }

    public DeltaRequest(String sessionId, boolean recordAllActions) {
        this.recordAllActions = recordAllActions;
        if (sessionId != null) {
            this.setSessionId(sessionId);
        }
    }

    public void setAttribute(String name, Object value) {
        int action = value == null ? 1 : 0;
        this.addAction(0, action, name, value);
    }

    public void removeAttribute(String name) {
        int action = 1;
        this.addAction(0, action, name, null);
    }

    public void setMaxInactiveInterval(int interval) {
        int action = 0;
        this.addAction(3, action, NAME_MAXINTERVAL, new Integer(interval));
    }

    public void setPrincipal(Principal p) {
        int action = p == null ? 1 : 0;
        SerializablePrincipal sp = null;
        if (p != null) {
            if (p instanceof GenericPrincipal) {
                sp = SerializablePrincipal.createPrincipal((GenericPrincipal)p);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("deltaRequest.showPrincipal", (Object)p.getName(), (Object)this.getSessionId()));
                }
            } else {
                log.error((Object)sm.getString("deltaRequest.wrongPrincipalClass", (Object)p.getClass().getName()));
            }
        }
        this.addAction(1, action, NAME_PRINCIPAL, sp);
    }

    public void setNew(boolean n) {
        int action = 0;
        this.addAction(2, action, NAME_ISNEW, new Boolean(n));
    }

    protected synchronized void addAction(int type, int action, String name, Object value) {
        AttributeInfo info = null;
        if (this.actionPool.size() > 0) {
            try {
                info = (AttributeInfo)this.actionPool.removeFirst();
            }
            catch (Exception x) {
                log.error((Object)"Unable to remove element:", (Throwable)x);
                info = new AttributeInfo(type, action, name, value);
            }
            info.init(type, action, name, value);
        } else {
            info = new AttributeInfo(type, action, name, value);
        }
        if (!this.recordAllActions) {
            try {
                this.actions.remove(info);
            }
            catch (NoSuchElementException x) {
                // empty catch block
            }
        }
        this.actions.addLast(info);
    }

    public void execute(DeltaSession session) {
        this.execute(session, true);
    }

    public synchronized void execute(DeltaSession session, boolean notifyListeners) {
        if (!this.sessionId.equals(session.getId())) {
            throw new IllegalArgumentException("Session id mismatch, not executing the delta request");
        }
        session.access();
        block6: for (int i = 0; i < this.actions.size(); ++i) {
            AttributeInfo info = (AttributeInfo)this.actions.get(i);
            switch (info.getType()) {
                case 0: {
                    if (info.getAction() == 0) {
                        session.setAttribute(info.getName(), info.getValue(), notifyListeners, false);
                        continue block6;
                    }
                    session.removeAttribute(info.getName(), notifyListeners, false);
                    continue block6;
                }
                case 2: {
                    session.setNew((Boolean)info.getValue(), false);
                    continue block6;
                }
                case 3: {
                    session.setMaxInactiveInterval((Integer)info.getValue(), false);
                    continue block6;
                }
                case 1: {
                    GenericPrincipal p = null;
                    if (info.getAction() == 0) {
                        SerializablePrincipal sp = (SerializablePrincipal)info.getValue();
                        p = sp.getPrincipal(session.getManager().getContainer().getRealm());
                    }
                    session.setPrincipal((Principal)p, false);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Invalid attribute info type=" + info);
                }
            }
        }
        session.endAccess();
        this.reset();
    }

    public synchronized void reset() {
        while (this.actions.size() > 0) {
            try {
                AttributeInfo info = (AttributeInfo)this.actions.removeFirst();
                info.recycle();
                this.actionPool.addLast(info);
            }
            catch (Exception x) {
                log.error((Object)"Unable to remove element", (Throwable)x);
            }
        }
        this.actions.clear();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
        if (sessionId == null) {
            new Exception("Session Id is null for setSessionId").fillInStackTrace().printStackTrace();
        }
    }

    public int getSize() {
        return this.actions.size();
    }

    public synchronized void clear() {
        this.actions.clear();
        this.actionPool.clear();
    }

    public synchronized void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.reset();
        this.sessionId = in.readUTF();
        this.recordAllActions = in.readBoolean();
        int cnt = in.readInt();
        if (this.actions == null) {
            this.actions = new LinkedList();
        } else {
            this.actions.clear();
        }
        for (int i = 0; i < cnt; ++i) {
            AttributeInfo info = null;
            if (this.actionPool.size() > 0) {
                try {
                    info = (AttributeInfo)this.actionPool.removeFirst();
                }
                catch (Exception x) {
                    log.error((Object)"Unable to remove element", (Throwable)x);
                    info = new AttributeInfo(-1, -1, null, null);
                }
            } else {
                info = new AttributeInfo(-1, -1, null, null);
            }
            info.readExternal(in);
            this.actions.addLast(info);
        }
    }

    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getSessionId());
        out.writeBoolean(this.recordAllActions);
        out.writeInt(this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            AttributeInfo info = (AttributeInfo)this.actions.get(i);
            info.writeExternal(out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AttributeInfo
    implements Externalizable {
        private String name = null;
        private Object value = null;
        private int action;
        private int type;

        public AttributeInfo() {
        }

        public AttributeInfo(int type, int action, String name, Object value) {
            this.init(type, action, name, value);
        }

        public void init(int type, int action, String name, Object value) {
            this.name = name;
            this.value = value;
            this.action = action;
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public int getAction() {
            return this.action;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String getName() {
            return this.name;
        }

        public void recycle() {
            this.name = null;
            this.value = null;
            this.type = -1;
            this.action = -1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AttributeInfo)) {
                return false;
            }
            AttributeInfo other = (AttributeInfo)o;
            return other.getName().equals(this.getName());
        }

        public synchronized void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.action = in.readInt();
            this.name = in.readUTF();
            this.value = in.readObject();
        }

        public synchronized void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.getType());
            out.writeInt(this.getAction());
            out.writeUTF(this.getName());
            out.writeObject(this.getValue());
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("AttributeInfo[type=");
            buf.append(this.getType()).append(", action=").append(this.getAction());
            buf.append(", name=").append(this.getName()).append(", value=").append(this.getValue());
            buf.append(", addr=").append(super.toString()).append("]");
            return buf.toString();
        }
    }
}

