/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements;

import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.DynamicTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateContext;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.RemoveFirstPrependMarker;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SqlTagContext {
    private StringWriter sw;
    private PrintWriter out;
    private HashMap attributes;
    private LinkedList removeFirstPrependStack;
    private LinkedList iterateContextStack;
    private ArrayList parameterMappings = new ArrayList();

    public SqlTagContext() {
        this.sw = new StringWriter();
        this.out = new PrintWriter(this.sw);
        this.attributes = new HashMap();
        this.removeFirstPrependStack = new LinkedList();
        this.iterateContextStack = new LinkedList();
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public String getBodyText() {
        this.out.flush();
        return this.sw.getBuffer().toString();
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public void addParameterMapping(ParameterMapping mapping) {
        this.parameterMappings.add(mapping);
    }

    public List getParameterMappings() {
        return this.parameterMappings;
    }

    public boolean isEmptyRemoveFirtPrepend() {
        return this.removeFirstPrependStack.size() <= 0;
    }

    public boolean peekRemoveFirstPrependMarker(SqlTag sqlTag) {
        RemoveFirstPrependMarker removeFirstPrepend = (RemoveFirstPrependMarker)this.removeFirstPrependStack.get(1);
        return removeFirstPrepend.isRemoveFirstPrepend();
    }

    public void popRemoveFirstPrependMarker(SqlTag tag) {
        RemoveFirstPrependMarker removeFirstPrepend = (RemoveFirstPrependMarker)this.removeFirstPrependStack.getFirst();
        if (tag == removeFirstPrepend.getSqlTag()) {
            this.removeFirstPrependStack.removeFirst();
        }
    }

    public void pushRemoveFirstPrependMarker(SqlTag tag) {
        if (tag.getHandler() instanceof DynamicTagHandler) {
            if (tag.isPrependAvailable()) {
                this.removeFirstPrependStack.addFirst(new RemoveFirstPrependMarker(tag, true));
            } else {
                this.removeFirstPrependStack.addFirst(new RemoveFirstPrependMarker(tag, false));
            }
        } else if ("true".equals(tag.getRemoveFirstPrepend())) {
            this.removeFirstPrependStack.addFirst(new RemoveFirstPrependMarker(tag, true));
        } else if (!tag.isPrependAvailable() && !"true".equals(tag.getRemoveFirstPrepend()) && tag.getParent() != null) {
            if ("true".equals(tag.getParent().getRemoveFirstPrepend())) {
                this.removeFirstPrependStack.addFirst(new RemoveFirstPrependMarker(tag, true));
            }
        } else {
            this.removeFirstPrependStack.addFirst(new RemoveFirstPrependMarker(tag, false));
        }
    }

    public void disableRemoveFirstPrependMarker() {
        ((RemoveFirstPrependMarker)this.removeFirstPrependStack.get(1)).setRemoveFirstPrepend(false);
    }

    public void pushIterateContext(IterateContext iterateContext) {
        this.iterateContextStack.addFirst(iterateContext);
    }

    public IterateContext popIterateContext() {
        IterateContext retVal = null;
        if (!this.iterateContextStack.isEmpty()) {
            retVal = (IterateContext)this.iterateContextStack.removeFirst();
        }
        return retVal;
    }

    public IterateContext peekIterateContext() {
        IterateContext retVal = null;
        if (!this.iterateContextStack.isEmpty()) {
            retVal = (IterateContext)this.iterateContextStack.getFirst();
        }
        return retVal;
    }
}

