/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.components;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.table.components.TableColumnModelSource;
import org.apache.tapestry.contrib.table.components.TableMessages;
import org.apache.tapestry.contrib.table.components.TableViewSessionStateManager;
import org.apache.tapestry.contrib.table.model.IAdvancedTableColumnSource;
import org.apache.tapestry.contrib.table.model.IBasicTableModel;
import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ITableColumnModel;
import org.apache.tapestry.contrib.table.model.ITableModel;
import org.apache.tapestry.contrib.table.model.ITableModelSource;
import org.apache.tapestry.contrib.table.model.ITablePagingState;
import org.apache.tapestry.contrib.table.model.ITableSessionStateManager;
import org.apache.tapestry.contrib.table.model.ITableSessionStoreManager;
import org.apache.tapestry.contrib.table.model.common.BasicTableModelWrap;
import org.apache.tapestry.contrib.table.model.simple.SimpleListTableDataModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumnModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableState;
import org.apache.tapestry.event.PageBeginRenderListener;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;

public abstract class TableView
extends BaseComponent
implements PageDetachListener,
PageBeginRenderListener,
ITableModelSource {
    private ITableSessionStateManager m_objDefaultSessionStateManager = null;
    private ITableColumnModel m_objColumnModel = null;
    private ITableModel m_objTableModel;
    private ITableModel m_objCachedTableModelValue;

    public abstract TableColumnModelSource getModelSource();

    public abstract IAdvancedTableColumnSource getColumnSource();

    public abstract ITableModel getTableModelValue();

    public abstract Object getSource();

    public abstract Object getColumns();

    public abstract int getInitialPage();

    public abstract String getInitialSortColumn();

    public abstract boolean getInitialSortOrder();

    public abstract ITableSessionStateManager getTableSessionStateManager();

    public abstract ITableSessionStoreManager getTableSessionStoreManager();

    public abstract IComponent getColumnSettingsContainer();

    public abstract int getPageSize();

    public abstract String getPersist();

    public abstract Serializable getSessionState();

    public abstract void setSessionState(Serializable var1);

    public abstract Serializable getClientState();

    public abstract void setClientState(Serializable var1);

    public abstract Serializable getClientAppState();

    public abstract void setClientAppState(Serializable var1);

    public TableView() {
        this.initialize();
    }

    public void pageDetached(PageEvent objEvent) {
        this.initialize();
    }

    private void initialize() {
        this.m_objTableModel = null;
        this.m_objCachedTableModelValue = null;
    }

    public void reset() {
        this.initialize();
        this.storeSessionState(null);
    }

    public ITableModel getCachedTableModelValue() {
        if (this.m_objCachedTableModelValue == null) {
            this.m_objCachedTableModelValue = this.getTableModelValue();
        }
        return this.m_objCachedTableModelValue;
    }

    public ITableModel getTableModel() {
        if (this.m_objTableModel == null) {
            Serializable objState = this.loadSessionState();
            ITableSessionStateManager objStateManager = this.getTableSessionStateManager();
            this.m_objTableModel = objStateManager.recreateTableModel(objState);
        }
        if (this.m_objTableModel == null) {
            this.m_objTableModel = this.getCachedTableModelValue();
        }
        if (this.m_objTableModel == null) {
            this.m_objTableModel = this.generateTableModel(null);
        }
        if (this.m_objTableModel == null) {
            throw new ApplicationRuntimeException(TableMessages.missingTableModel(this));
        }
        return this.m_objTableModel;
    }

    protected ITableModel generateTableModel(SimpleTableState objState) {
        ITableColumnModel objColumnModel;
        if (objState == null) {
            objState = new SimpleTableState();
            objState.getSortingState().setSortColumn(this.getInitialSortColumn(), this.getInitialSortOrder());
            objState.getPagingState().setCurrentPage(this.getInitialPage());
        }
        if (this.isParameterBound("pageSize")) {
            objState.getPagingState().setPageSize(this.getPageSize());
        }
        if ((objColumnModel = this.getTableColumnModel()) == null) {
            return null;
        }
        Object objSourceValue = this.getSource();
        if (objSourceValue == null) {
            return null;
        }
        if (objSourceValue instanceof IBasicTableModel) {
            return new BasicTableModelWrap((IBasicTableModel)objSourceValue, objColumnModel, objState);
        }
        SimpleListTableDataModel objDataModel = null;
        if (objSourceValue instanceof Object[]) {
            objDataModel = new SimpleListTableDataModel((Object[])objSourceValue);
        } else if (objSourceValue instanceof List) {
            objDataModel = new SimpleListTableDataModel((List)objSourceValue);
        } else if (objSourceValue instanceof Collection) {
            objDataModel = new SimpleListTableDataModel((Collection)objSourceValue);
        } else if (objSourceValue instanceof Iterator) {
            objDataModel = new SimpleListTableDataModel((Iterator)objSourceValue);
        }
        if (objDataModel == null) {
            throw new ApplicationRuntimeException(TableMessages.invalidTableSource(this, objSourceValue));
        }
        return new SimpleTableModel(objDataModel, objColumnModel, objState);
    }

    protected ITableColumnModel getTableColumnModel() {
        ArrayList objColumns = this.getColumns();
        if (objColumns == null) {
            return null;
        }
        if (objColumns instanceof ITableColumnModel) {
            return (ITableColumnModel)((Object)objColumns);
        }
        if (objColumns instanceof Iterator) {
            Iterator objColumnsIterator = (Iterator)((Object)objColumns);
            ArrayList arrColumnsList = new ArrayList();
            this.addAll(arrColumnsList, objColumnsIterator);
            objColumns = arrColumnsList;
        }
        if (objColumns instanceof List) {
            List arrColumnsList = objColumns;
            int nColumnsNumber = arrColumnsList.size();
            for (int i = 0; i < nColumnsNumber; ++i) {
                if (arrColumnsList.get(i) instanceof ITableColumn) continue;
                throw new ApplicationRuntimeException(TableMessages.columnsOnlyPlease(this));
            }
            return new SimpleTableColumnModel(arrColumnsList);
        }
        if (objColumns instanceof ITableColumn[]) {
            return new SimpleTableColumnModel((ITableColumn[])objColumns);
        }
        if (objColumns instanceof String) {
            String strColumns = (String)((Object)objColumns);
            if (this.getBinding("columns").isInvariant()) {
                if (this.m_objColumnModel == null) {
                    this.m_objColumnModel = this.generateTableColumnModel(strColumns);
                }
                return this.m_objColumnModel;
            }
            return this.generateTableColumnModel(strColumns);
        }
        throw new ApplicationRuntimeException(TableMessages.invalidTableColumns(this, objColumns));
    }

    private void addAll(List arrColumnsList, Iterator objColumnsIterator) {
        while (objColumnsIterator.hasNext()) {
            arrColumnsList.add(objColumnsIterator.next());
        }
    }

    protected ITableColumnModel generateTableColumnModel(String strDesc) {
        IComponent objColumnSettingsContainer = this.getColumnSettingsContainer();
        IAdvancedTableColumnSource objColumnSource = this.getColumnSource();
        return this.getModelSource().generateTableColumnModel(objColumnSource, strDesc, this, objColumnSettingsContainer);
    }

    public ITableSessionStateManager getDefaultTableSessionStateManager() {
        if (this.m_objDefaultSessionStateManager == null) {
            this.m_objDefaultSessionStateManager = new TableViewSessionStateManager(this);
        }
        return this.m_objDefaultSessionStateManager;
    }

    public void fireObservedStateChange() {
        this.saveSessionState();
    }

    public void pageBeginRender(PageEvent event) {
        if (this.m_objTableModel != null) {
            this.saveSessionState();
        }
    }

    protected void saveSessionState() {
        ITableModel objModel = this.getTableModel();
        Serializable objState = this.getTableSessionStateManager().getSessionState(objModel);
        this.storeSessionState(objState);
    }

    protected Serializable loadSessionState() {
        ITableSessionStoreManager objManager = this.getTableSessionStoreManager();
        if (objManager != null) {
            return objManager.loadState(this.getPage().getRequestCycle());
        }
        String strPersist = this.getPersist();
        if (strPersist.equals("client") || strPersist.equals("client:page")) {
            return this.getClientState();
        }
        if (strPersist.equals("client:app")) {
            return this.getClientAppState();
        }
        return this.getSessionState();
    }

    protected void storeSessionState(Serializable objState) {
        ITableSessionStoreManager objManager = this.getTableSessionStoreManager();
        if (objManager != null) {
            objManager.saveState(this.getPage().getRequestCycle(), objState);
        } else {
            String strPersist = this.getPersist();
            if (strPersist.equals("client") || strPersist.equals("client:page")) {
                this.setClientState(objState);
            } else if (strPersist.equals("client:app")) {
                this.setClientAppState(objState);
            } else {
                this.setSessionState(objState);
            }
        }
    }

    protected void validateValues() {
        int nPageCount;
        ITableModel objModel = this.getTableModel();
        ITablePagingState objPagingState = objModel.getPagingState();
        int nCurrentPage = objPagingState.getCurrentPage();
        if (nCurrentPage >= (nPageCount = objModel.getPageCount())) {
            nCurrentPage = nPageCount - 1;
            objPagingState.setCurrentPage(nCurrentPage);
        }
        if (nCurrentPage < 0) {
            nCurrentPage = 0;
            objPagingState.setCurrentPage(nCurrentPage);
        }
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Object objOldValue = cycle.getAttribute("org.apache.tapestry.contrib.table.model.ITableModelSource");
        cycle.setAttribute("org.apache.tapestry.contrib.table.model.ITableModelSource", (Object)this);
        this.initialize();
        this.validateValues();
        super.renderComponent(writer, cycle);
        cycle.setAttribute("org.apache.tapestry.contrib.table.model.ITableModelSource", objOldValue);
    }
}

