/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import jp.moja.socklet.util.security.AccessController;
import jp.wda.gpss.GeneralSocklet;
import jp.wda.gpss.Progress;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.SockletDeployingException;
import jp.wda.gpss.system.Configuration;
import jp.wda.gpss.system.ConfigurationError;
import jp.wda.gpss.system.DefaultSocklet;
import jp.wda.gpss.system.ScriptInfo;
import jp.wda.gpss.system.ScriptSocklet;
import jp.wda.gpss.system.SocketProcessorBase;
import jp.wda.gpss.system.SockletLoader;
import jp.wda.gpss.system.SystemCommandSocklet;
import jp.wda.gpss.util.Finder;
import jp.wda.gpss.util.FinderElement;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public abstract class ExecutableBase
implements Runnable {
    public static final String DEFAULT_APPLICATION_NAME = "Default";
    public static final String SYSTEM_APPLICATION_NAME = "SystemCommandSocklet";
    public static final String DEPLOY_BY_SYSTEM = "BySystemServer";
    public static final int DEFAULT_BUFFER_SIZE = 30;
    protected SockletLoader scriptLoader;
    private Configuration config;
    private SystemCommandSocklet syscomsocklet = null;
    private ArrayList apps;
    private Progress loggers = new Progress();
    private boolean restartsw = false;

    ExecutableBase(Configuration config) {
        this.config = config;
        this.startServer();
    }

    public String getEncoding() {
        return this.config.getEncoding();
    }

    public int getPort() {
        return this.config.getPort();
    }

    public int getInitialTimeout() {
        return this.config.getTimeout();
    }

    public int getMessagesBufferSize() {
        return this.config.getMessagesBufferSize();
    }

    boolean isUsingDefault() {
        return this.config.isUsingDefault();
    }

    SockletDeployInfo getSockletInformation(String name) {
        return this.config.getInformation(name);
    }

    ScriptInfo getScriptInfomation(String ext) {
        return this.config.getScriptInfomation(ext);
    }

    SockletDeployInfo getScriptSockletInformation(String name) {
        return this.config.getScriptApplicationInfo(name);
    }

    AccessController getSecurityController() {
        return this.config.getSecurityController();
    }

    void reloadSystemCommandInfo() {
        this.syscomsocklet.setInfo(this, this.config.getSyscomInfo());
    }

    boolean checkSystemCommandSocklet(SystemCommandSocklet sys) {
        return sys != null && sys == this.syscomsocklet;
    }

    void notifyToSystemCommandSocklet(Socklet app) {
        if (this.syscomsocklet != null && !(app instanceof SystemCommandSocklet) && DEPLOY_BY_SYSTEM.equals(app.deployedBy())) {
            this.syscomsocklet.sendAllToClients("ntf=" + app.getName() + ":" + app.countClients());
        }
    }

    Iterator getSocklets() {
        return new ArrayList(this.apps).iterator();
    }

    public Socklet getSocklet(String appname) {
        return (Socklet)new SAFinderByName(appname).get(this.apps);
    }

    public String getSockletsList() {
        StringBuffer ret = new StringBuffer();
        ret.append("lst=");
        Iterator it = this.getSocklets();
        boolean delsw = it.hasNext();
        while (it.hasNext()) {
            Socklet socklet = (Socklet)it.next();
            if (socklet == this.syscomsocklet || !DEPLOY_BY_SYSTEM.equals(socklet.deployedBy())) continue;
            ret.append(socklet.getName());
            ret.append(':');
            ret.append(socklet.countClients());
            ret.append(',');
        }
        if (delsw) {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    void terminateSocklet(Socklet socklet, String message) {
        if (socklet == null) {
            return;
        }
        socklet.disconnectAllClients(message);
        socklet.destroy();
        this.apps.remove(socklet);
        this.terminateLinkedSocklets(new SAFinderByDeployer(socklet.getName()).getList(this.apps), message);
    }

    private void terminateLinkedSocklets(List links, String message) {
        int i = 0;
        while (i < links.size()) {
            this.terminateSocklet((Socklet)links.get(i), message);
            ++i;
        }
    }

    public Progress getProgress() {
        return this.loggers;
    }

    public void doInitialCommand(SocketProcessorBase client, String command) {
        Socklet app;
        if (command.startsWith("<cross-domain-request") || command.startsWith("<policy-file-request")) {
            String xml = this.config.getCrossDomainPolicy();
            client.send(xml);
            return;
        }
        String[] commandbuf = new String[]{command};
        String appname = ExecutableBase.getNextCommand(commandbuf, ":");
        if (appname == null || appname.length() == 0) {
            appname = DEFAULT_APPLICATION_NAME;
        }
        if ((app = this.getSocklet(appname)) == null) {
            if (this.isUsingDefault()) {
                app = (Socklet)this.apps.get(0);
            } else {
                client.setApplication(null);
                return;
            }
        }
        app.addClient(client);
        client.setApplication(app);
        this.notifyToSystemCommandSocklet(app);
        this.loggers.syslog("[" + client.getIPAddress() + "] connect to \"" + app.getName() + "\" (ID:" + client.getClientID() + ")");
        if (commandbuf[0] == null) {
            return;
        }
        String username = ExecutableBase.getNextCommand(commandbuf, ":");
        if (username != null && username.length() > 0) {
            client.setUserName(username);
        }
        if (commandbuf[0] == null) {
            return;
        }
        String password = ExecutableBase.getNextCommand(commandbuf, ":");
        if (password != null && password.length() > 0) {
            client.setPassword(password);
        }
        if (commandbuf[0] == null) {
            return;
        }
        String params = ExecutableBase.getNextCommand(commandbuf, ":");
        if (params != null && params.length() > 0) {
            String[] paramsbuf = new String[]{params};
            while (paramsbuf[0] != null) {
                String param = ExecutableBase.getNextCommand(paramsbuf, "&");
                client.addInitParam(param);
            }
        }
    }

    public void run() {
        block3: {
            try {
                this.accept();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                if (this.restartsw) {
                    this.startServer();
                }
                throw throwable;
            }
            Object var1_3 = null;
            if (!this.restartsw) break block3;
            this.startServer();
        }
    }

    void setRestartAfterShutdown() {
        this.restartsw = true;
    }

    void loadConfig() throws ConfigurationError {
        this.config.loadConfig();
        if (!this.config.setSysLog()) {
            this.config.addLogger("gpssSystemLogger", "WARN", "./logs/gpss.log", "UTF-8", "[%d{yyyy/MM/dd HH:mm:ss} %-5p] %m%n");
        }
        PropertyConfigurator.configure((Properties)this.config.getLogProperties());
        Iterator lit = this.config.getLoggerNames().iterator();
        while (lit.hasNext()) {
            String name = (String)lit.next();
            Logger logger = Logger.getLogger((String)name);
            if (logger == null) continue;
            this.loggers.setLogger(name, logger);
        }
    }

    void startServer() {
        this.apps = new ArrayList();
        try {
            this.loadConfig();
        }
        catch (ConfigurationError e) {
            System.out.println(e.toString());
            System.out.println("\u30b5\u30fc\u30d0\u30fc\u3092\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            return;
        }
        if (!this.config.setDefault()) {
            DefaultSocklet dsock = new DefaultSocklet();
            dsock.init(new SockletDeployInfo(DEFAULT_APPLICATION_NAME), null, this.loggers);
            this.apps.add(dsock);
        }
        this.syscomsocklet = new SystemCommandSocklet();
        this.syscomsocklet.setMain(this);
        this.syscomsocklet.init(this.config.getSyscomInfo(), null, this.loggers);
        this.apps.add(this.syscomsocklet);
        this.scriptLoader = new SockletLoader(this.config.getClasspath(), Thread.currentThread().getContextClassLoader());
        Iterator it = this.config.getInformations().iterator();
        while (it.hasNext()) {
            SockletDeployInfo sockletInfo = (SockletDeployInfo)it.next();
            try {
                Socklet socklet = this.deployNewSocklet(sockletInfo, DEPLOY_BY_SYSTEM, null);
            }
            catch (SockletDeployingException e) {
                this.loggers.errlog("Socklet\u306e\u914d\u5099\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                continue;
            }
            this.loggers.syslog("Socklet\"" + sockletInfo.getName() + "\"(" + sockletInfo.getClassname() + ")\u3092\u914d\u5099\u3057\u307e\u3057\u305f\u3002");
        }
        it = this.config.getScriptInfomations().iterator();
        if (it.hasNext()) {
            this.loggers.syslog("\u30b9\u30af\u30ea\u30d7\u30c8Socklet\u306e\u914d\u5099\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
        }
        while (it.hasNext()) {
            ScriptInfo info = (ScriptInfo)it.next();
            this.loggers.syslog(String.valueOf(info.getDirectory().getAbsolutePath()) + "\u306b\u3042\u308b" + info.getExtention() + "\u30b9\u30af\u30ea\u30d7\u30c8\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u914d\u5099\u3057\u307e\u3059\u3002");
            this.deployScripts(info.getDirectory(), info, "");
        }
        this.restartsw = false;
        new Thread((Runnable)this, "MainServer").start();
    }

    Socklet deployNewSocklet(SockletDeployInfo sockletinfo, String deployer, SockletLoader loader) throws SockletDeployingException {
        if (sockletinfo == null) {
            return null;
        }
        if (sockletinfo.getName() == null || sockletinfo.getName().length() == 0) {
            throw new SockletDeployingException("\u914d\u5099\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (sockletinfo.getClassname() == null || sockletinfo.getClassname().length() == 0) {
            throw new SockletDeployingException("\u914d\u5099\u540d" + sockletinfo.getName() + "\u306eSocklet\u30af\u30e9\u30b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.getSocklet(sockletinfo.getName()) != null) {
            throw new SockletDeployingException("\u914d\u5099\u540d" + sockletinfo.getName() + "\u306eSocklet\u306f\u65e2\u306b\u914d\u5099\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        if (loader == null) {
            loader = new SockletLoader(this.config.getClasspath(), (ClassLoader)this.scriptLoader);
        }
        Socklet socklet = null;
        try {
            socklet = loader.loadSocklet(sockletinfo.getClassname());
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new SockletDeployingException("\u30af\u30e9\u30b9[" + sockletinfo.getName() + "(" + sockletinfo.getClassname() + ")]\u306f\u3001Socklet\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        catch (Throwable e) {
            throw new SockletDeployingException("Socklet[" + sockletinfo.getName() + "(" + sockletinfo.getClassname() + ")]\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n" + e.toString());
        }
        if (socklet == null) {
            throw new SockletDeployingException("Socklet[" + sockletinfo.getName() + "(" + sockletinfo.getClassname() + ")]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        socklet.deployedBy(this, deployer);
        if (socklet instanceof GeneralSocklet) {
            ((GeneralSocklet)socklet).setMain(this);
        }
        this.apps.add(socklet);
        ArrayList links = new ArrayList();
        HashMap<String, Socklet> linkedSocklets = new HashMap<String, Socklet>();
        socklet.init(sockletinfo, links, this.loggers);
        Iterator it = links.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof SockletDeployInfo)) continue;
            try {
                Socklet linkSocklet = this.deployNewSocklet((SockletDeployInfo)next, socklet.getName(), loader);
                if (linkSocklet == null || !linkSocklet.allowAccessFromOtherSocklet(socklet)) continue;
                linkedSocklets.put(((SockletDeployInfo)next).getName(), linkSocklet);
            }
            catch (SockletDeployingException e) {
                this.loggers.errlog(String.valueOf(socklet.getName()) + "\u306e\u9023\u7d50Socklet\u914d\u5099\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
        }
        socklet.afterDeployedLinks(linkedSocklets);
        return socklet;
    }

    private void deployScripts(File dir, ScriptInfo info, String header) {
        File[] childs = dir.listFiles();
        int i = 0;
        while (i < childs.length) {
            block7: {
                String ext;
                String name = childs[i].getName();
                if (childs[i].isDirectory()) {
                    this.deployScripts(childs[i], info, String.valueOf(header) + name + ".");
                } else if (name.length() >= info.getExtention().length() && (ext = name.substring(name.length() - info.getExtention().length())).equalsIgnoreCase(info.getExtention())) {
                    SockletDeployInfo sockletInfo;
                    block6: {
                        sockletInfo = this.config.getScriptApplicationInfo(String.valueOf(header) + name.substring(0, name.length() - ext.length()));
                        sockletInfo.addInitParam("source", childs[i].getAbsolutePath());
                        sockletInfo.addInitParam("sourceEncoding", info.getEncoding());
                        sockletInfo.setClassname(info.getJSClass().getName());
                        try {
                            Socklet socklet = this.deployNewSocklet(sockletInfo, DEPLOY_BY_SYSTEM, this.scriptLoader);
                            if (!(socklet instanceof ScriptSocklet)) break block6;
                            ((ScriptSocklet)socklet).setExtention(ext);
                            ((ScriptSocklet)socklet).setScriptFile(childs[i]);
                        }
                        catch (SockletDeployingException e) {
                            this.loggers.errlog("Script Socklet\u306e\u914d\u5099\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                            break block7;
                        }
                    }
                    this.loggers.syslog("Script Socklet\"" + sockletInfo.getName() + "\"\u3092\u914d\u5099\u3057\u307e\u3057\u305f\u3002");
                }
            }
            ++i;
        }
    }

    protected static String getNextCommand(String[] command, String separator) {
        String next;
        int sep = command[0].indexOf(separator);
        if (sep < 0) {
            next = command[0];
            command[0] = null;
        } else {
            next = command[0].substring(0, sep);
            command[0] = command[0].length() > sep + 1 ? command[0].substring(sep + 1) : null;
        }
        return next;
    }

    public abstract void accept();

    abstract void shutdown(SystemCommandSocklet var1);

    abstract void restart(SystemCommandSocklet var1);

    abstract boolean restartSocklet(SystemCommandSocklet var1, String var2);

    abstract boolean reloadConfig(SystemCommandSocklet var1);

    private class SAFinderByName
    extends Finder {
        public SAFinderByName(String name) {
            this.group.add(new SAFinderByNameElement(true, name));
        }

        public SAFinderByName(boolean not, String name) {
            this.group.add(new SAFinderByNameElement(not, name));
        }

        public Object getReturnValue(Object elem) {
            return elem;
        }

        private class SAFinderByNameElement
        extends FinderElement {
            SAFinderByNameElement(boolean not, String name) {
                super(not, name);
            }

            public Object getFindValue(Object elem) {
                if (!(elem instanceof Socklet)) {
                    return null;
                }
                return ((Socklet)elem).getName();
            }
        }
    }

    private class SAFinderByDeployer
    extends Finder {
        public SAFinderByDeployer(String name) {
            this.group.add(new SAFinderByDeployerElement(true, name));
        }

        public SAFinderByDeployer(boolean not, String name) {
            this.group.add(new SAFinderByDeployerElement(not, name));
        }

        public Object getReturnValue(Object elem) {
            return elem;
        }

        private class SAFinderByDeployerElement
        extends FinderElement {
            SAFinderByDeployerElement(boolean not, String name) {
                super(not, name);
            }

            public Object getFindValue(Object elem) {
                if (!(elem instanceof Socklet)) {
                    return null;
                }
                return ((Socklet)elem).deployedBy();
            }
        }
    }
}

