/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jp.wda.gpss.system.InitParamContainer;
import jp.wda.gpss.util.Finder;
import jp.wda.gpss.util.FinderElement;

public class InitParamContainerImpl
implements InitParamContainer {
    private Vector initparams = new Vector();

    public void addInitParam(String key, String value) {
        this.initparams.add(new Param(key, value));
    }

    public void setInitParam(String key, String value) {
        Iterator it = new ArrayList(this.initparams).iterator();
        while (it.hasNext()) {
            Param param = (Param)it.next();
            if (!key.equals(param.key)) continue;
            param.value = value;
            return;
        }
        this.initparams.add(new Param(key, value));
    }

    public String getInitParam(String key) {
        return (String)new PFinder(key).get(this.initparams);
    }

    public List getInitParams(String key) {
        return new PFinder(key).getList(this.initparams);
    }

    public List getInitParams() {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator it = this.initparams.iterator();
        while (it.hasNext()) {
            ret.add(((Param)it.next()).value);
        }
        return ret;
    }

    public List getInitParamKeys() {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator it = this.initparams.iterator();
        while (it.hasNext()) {
            Param param = (Param)it.next();
            if (ret.contains(param.key)) continue;
            ret.add(param.key);
        }
        return ret;
    }

    public boolean hasInitParam(String key) {
        return this.getInitParam(key) != null;
    }

    public void copyInitParamsTo(InitParamContainerImpl to) {
        Iterator it = this.initparams.iterator();
        while (it.hasNext()) {
            Param param = (Param)it.next();
            to.addInitParam(param.key, param.value);
        }
    }

    class Param {
        String key;
        String value;

        Param(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public class PFinder
    extends Finder {
        public PFinder(String username) {
            this.group.add(new PFinderElement(true, username));
        }

        public PFinder(boolean not, String username) {
            this.group.add(new PFinderElement(not, username));
        }

        public Object getReturnValue(Object elem) {
            return ((Param)elem).value;
        }

        private class PFinderElement
        extends FinderElement {
            PFinderElement(boolean not, String key) {
                super(not, key);
            }

            public Object getFindValue(Object elem) {
                if (!(elem instanceof Param)) {
                    return null;
                }
                return ((Param)elem).key;
            }
        }
    }
}

