package jp.moja.socklet.util.security;

import java.util.ArrayList;

import jp.wda.gpss.SocketProcessor;

/**
 * ڑs`FbJ[
 * @author TakenoriAdachi(TheCoolMuseum)
 */
public class LimitedConnectionChecker extends ClientChecker {

	private int maxConnection;
	
	private ArrayList connections;

	private int trueOperation;

	private int falseOperation;

	public LimitedConnectionChecker(int max, int trueOperation, int falseOperation) {
		this.maxConnection = max;
		connections = new ArrayList();
		this.trueOperation = trueOperation;
		this.falseOperation = falseOperation;
	}

	public synchronized int enter(SocketProcessor client) {
		connections.add(client);
		if (connections.size() <= maxConnection) {
			return trueOperation;
		}
		return falseOperation;
	}

	public synchronized void exit(SocketProcessor client) {
		connections.remove(client);
	}
}
