package jp.wda.gpss;

import java.lang.reflect.Method;

/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o
 * </B></I></FONT><BR>
 * w肳ꂽR}h̃\bhtNVĎsSockletNXB<BR>
 * R}h̉ߕ@́AparseCommand\bhI[o[ChALq܂B<BR>
 * ̓Iȉߕ@́AehNXB
 * 
 * @version	1.03		2003/09/20
 * @since		1.00008	2003/06/14
 * @author	amoi
 * @see jp.wda.gpss.GeneralSocklet
 */
public abstract class CommandSocklet extends GeneralSocklet {
	// I[o[Ch ///////////////////////////////////////////////////////////////////
	//                                                                        Override //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	public final boolean doCommand(SocketProcessor client, String command){
		// R}hsO
		Object preprocessed = null;
		try{
			preprocessed = preProcess(client, command);
		}catch(SockletException e){ return false; }
		
		CommandInfo cmd = parseCommand(client, command, preprocessed);
		if(cmd == null){ return false; }
		if(cmd.name == null){ return false; }
		
		if(execIgnoreCase(client) && cmd.name.length() > 0){
			cmd.name = cmd.name.substring(0, 1).toUpperCase() + 
					 (cmd.name.length() > 1 ? 
					  cmd.name.substring(1).toLowerCase() : "");
		}
		
		// \bh
		Method method = null;
		try{
			method = getClass().getMethod("cmd" + cmd.name, cmd.type);
		}catch(NoSuchMethodException e){
			return cmdUndefined(client, cmd.name, cmd.params);
		}catch(SecurityException e){
			e.printStackTrace();
			return false;
		}
		
		// R}h\bhs
		Object ret = null;
		try{
			ret = method.invoke(this, cmd.params);
		}catch(Throwable e){
			log(cmd.name + "R}hsɗO܂B", Progress.FATAL, e);
			return false;
		}
		
		if(ret instanceof Boolean){ return ((Boolean)ret).booleanValue(); }
		if(ret instanceof String) { return Boolean.getBoolean((String)ret); }
		if(ret instanceof Integer){ return ((Integer)ret).intValue() != 0; }
		
		return false;
	}
	
	/* ***********************************************************************>> */;
	/**
	 * ĂR}h͂A\bhtNV邽߂̏쐬܂B<BR>
	 * ڑ̃NCAgAR}hMĂƂɌĂ΂܂B<BR>
	 * hNXł͂̃\bhI[o[ChAR}h̉ߕ@LqĂB<BR>
	 * 
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param command MR}h
	 * @param preprocessed OʃIuWFNg
	 * @return sR}htNV\bh̖̓ԂĂB
	 */
	protected abstract CommandInfo parseCommand(SocketProcessor client, String command, Object preprocessed);
	
	/**
	 * sR}htNV\bh̖̓ێNX
	 */
	protected class CommandInfo{
		public String   name;
		public Class[]  type;
		public Object[] params;
	}
	
	/**
	 * R}htNV\bh`̏sȂ܂B
	 * 
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param command `̎sR}h
	 * @param params R}hl
	 * @return R}hsɐꍇ͐^Asꍇ͋U
	 * 	UԂƒɃNCAg\PbgI܂B
	 */
	public boolean cmdUndefined(SocketProcessor client, String command, Object[] params){
		return true;
	}
	
	/**
	 * R}hsOsȂ܂B<BR>
	 * ̃\bh̖߂ĺAR}htNV\bhɈn܂B<BR>
	 * SẴR}hɋʂ鏈Lqꍇ́Ã\bhI[o[ChĂB<BR>
	 * SockletExceptionO𓊂ƁAR}h̉߂𒆎~AdoCommandŒɋUԂ܂B
	 * 
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param command MR}h
	 * @return OʃIuWFNg
	 * @throws SockletException R}hߏ𒆎~ꍇB
	 */
	public Object preProcess(SocketProcessor client, String command) throws SockletException{
		return null;
	}
	
	/**
	 * R}h̑啶ʂ邩ǂ肵܂B
	 * ^Ԃꍇ́A啶ʂ܂B
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @return 啶ʂȂȂ^
	 */
	public boolean execIgnoreCase(SocketProcessor client){
		return true;
	}
}
