/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.security;

import java.util.ArrayList;
import java.util.List;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.security.ClientChecker;

public class AccessController {
    private List<ClientChecker> checkerChain = new ArrayList<ClientChecker>();

    public synchronized AccessController register(ClientChecker checker) {
        this.checkerChain.add(checker);
        return this;
    }

    public synchronized boolean enter(SocketProcessor client) {
        for (ClientChecker checker : this.checkerChain) {
            int result = checker.enter(client);
            if (result == ClientChecker.ACCEPT) {
                return true;
            }
            if (result != ClientChecker.REJECT) continue;
            return false;
        }
        return true;
    }

    public synchronized void exit(SocketProcessor client) {
        for (ClientChecker checker : this.checkerChain) {
            checker.exit(client);
        }
    }
}

