/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.ConstructorNotFoundRuntimeException;
import org.seasar.framework.beans.FieldNotFoundRuntimeException;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.beans.impl.PropertyDescImpl;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ArrayMap;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.ClassPoolUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConstructorUtil;
import org.seasar.framework.util.DoubleConversionUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.FloatConversionUtil;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.LongConversionUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ShortConversionUtil;
import org.seasar.framework.util.StringUtil;

public final class BeanDescImpl
implements BeanDesc {
    private static final Logger logger = Logger.getLogger(class$org$seasar$framework$beans$impl$BeanDescImpl == null ? (class$org$seasar$framework$beans$impl$BeanDescImpl = BeanDescImpl.class$("org.seasar.framework.beans.impl.BeanDescImpl")) : class$org$seasar$framework$beans$impl$BeanDescImpl);
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class[] EMPTY_PARAM_TYPES = new Class[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Class beanClass;
    private Constructor[] constructors;
    private CaseInsensitiveMap propertyDescCache = new CaseInsensitiveMap();
    private Map methodsCache = new HashMap();
    private Map fieldCache = new HashMap();
    private transient Set invalidPropertyNames = new HashSet();
    private Map constructorParameterNamesCache;
    private Map methodParameterNamesCache;
    static /* synthetic */ Class class$org$seasar$framework$beans$impl$BeanDescImpl;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Object;

    public BeanDescImpl(Class beanClass) throws EmptyRuntimeException {
        if (beanClass == null) {
            throw new EmptyRuntimeException("beanClass");
        }
        this.beanClass = beanClass;
        this.constructors = beanClass.getConstructors();
        this.setupPropertyDescs();
        this.setupMethods();
        this.setupFields();
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public boolean hasPropertyDesc(String propertyName) {
        return this.propertyDescCache.get(propertyName) != null;
    }

    public PropertyDesc getPropertyDesc(String propertyName) throws PropertyNotFoundRuntimeException {
        PropertyDesc pd = (PropertyDesc)this.propertyDescCache.get(propertyName);
        if (pd == null) {
            throw new PropertyNotFoundRuntimeException(this.beanClass, propertyName);
        }
        return pd;
    }

    private PropertyDesc getPropertyDesc0(String propertyName) {
        return (PropertyDesc)this.propertyDescCache.get(propertyName);
    }

    public PropertyDesc getPropertyDesc(int index) {
        return (PropertyDesc)this.propertyDescCache.get(index);
    }

    public int getPropertyDescSize() {
        return this.propertyDescCache.size();
    }

    public boolean hasField(String fieldName) {
        return this.fieldCache.get(fieldName) != null;
    }

    public Field getField(String fieldName) {
        Field field = (Field)this.fieldCache.get(fieldName);
        if (field == null) {
            throw new FieldNotFoundRuntimeException(this.beanClass, fieldName);
        }
        return field;
    }

    public Object getFieldValue(String fieldName, Object target) throws FieldNotFoundRuntimeException {
        Field field = this.getField(fieldName);
        return FieldUtil.get(field, target);
    }

    public Object newInstance(Object[] args) throws ConstructorNotFoundRuntimeException {
        Constructor constructor = this.getSuitableConstructor(args);
        return ConstructorUtil.newInstance(constructor, args);
    }

    public Object invoke(Object target, String methodName, Object[] args) {
        Method method = this.getSuitableMethod(methodName, args);
        return MethodUtil.invoke(method, target, args);
    }

    public Constructor getSuitableConstructor(Object[] args) throws ConstructorNotFoundRuntimeException {
        Constructor constructor;
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if ((constructor = this.findSuitableConstructor(args)) != null) {
            return constructor;
        }
        constructor = this.findSuitableConstructorAdjustNumber(args);
        if (constructor != null) {
            return constructor;
        }
        throw new ConstructorNotFoundRuntimeException(this.beanClass, args);
    }

    public Constructor getConstructor(Class[] paramTypes) {
        for (int i = 0; i < this.constructors.length; ++i) {
            if (!Arrays.equals(paramTypes, this.constructors[i].getParameterTypes())) continue;
            return this.constructors[i];
        }
        throw new ConstructorNotFoundRuntimeException(this.beanClass, paramTypes);
    }

    public Method getMethod(String methodName) {
        return this.getMethod(methodName, EMPTY_PARAM_TYPES);
    }

    public Method getMethod(String methodName, Class[] paramTypes) {
        Method[] methods = this.getMethods(methodName);
        for (int i = 0; i < methods.length; ++i) {
            if (!Arrays.equals(paramTypes, methods[i].getParameterTypes())) continue;
            return methods[i];
        }
        throw new MethodNotFoundRuntimeException(this.beanClass, methodName, paramTypes);
    }

    public Method[] getMethods(String methodName) throws MethodNotFoundRuntimeException {
        Method[] methods = (Method[])this.methodsCache.get(methodName);
        if (methods == null) {
            throw new MethodNotFoundRuntimeException(this.beanClass, methodName, null);
        }
        return methods;
    }

    public boolean hasMethod(String methodName) {
        return this.methodsCache.get(methodName) != null;
    }

    public String[] getMethodNames() {
        return this.methodsCache.keySet().toArray(new String[this.methodsCache.size()]);
    }

    public String[] getConstructorParameterNames(Class[] parameterTypes) {
        return this.getConstructorParameterNames(this.getConstructor(parameterTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConstructorParameterNames(Constructor constructor) {
        BeanDescImpl beanDescImpl = this;
        synchronized (beanDescImpl) {
            if (this.constructorParameterNamesCache == null) {
                this.setUpConstructorParameterNamesCache();
            }
        }
        if (!this.constructorParameterNamesCache.containsKey(constructor)) {
            throw new ConstructorNotFoundRuntimeException(this.beanClass, constructor.getParameterTypes());
        }
        return (String[])this.constructorParameterNamesCache.get(constructor);
    }

    public String[] getMethodParameterNames(String methodName, Class[] parameterTypes) {
        return this.getMethodParameterNames(this.getMethod(methodName, parameterTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMethodParameterNames(Method method) {
        BeanDescImpl beanDescImpl = this;
        synchronized (beanDescImpl) {
            if (this.methodParameterNamesCache == null) {
                this.setUpMethodParameterNamesCache();
            }
        }
        if (!this.methodParameterNamesCache.containsKey(method)) {
            throw new MethodNotFoundRuntimeException(this.beanClass, method.getName(), method.getParameterTypes());
        }
        return (String[])this.methodParameterNamesCache.get(method);
    }

    protected void setUpConstructorParameterNamesCache() {
        this.constructorParameterNamesCache = new HashMap();
        ClassPool pool = ClassPoolUtil.getClassPool(this.beanClass);
        for (int i = 0; i < this.constructors.length; ++i) {
            Constructor constructor = this.constructors[i];
            if (constructor.getParameterTypes().length == 0) {
                this.constructorParameterNamesCache.put(constructor, EMPTY_STRING_ARRAY);
                continue;
            }
            CtClass clazz = ClassPoolUtil.toCtClass(pool, constructor.getDeclaringClass());
            CtClass[] parameterTypes = ClassPoolUtil.toCtClassArray(pool, constructor.getParameterTypes());
            try {
                String[] names = this.getParameterNames(clazz, (CtBehavior)clazz.getDeclaredConstructor(parameterTypes));
                this.constructorParameterNamesCache.put(constructor, names);
                continue;
            }
            catch (NotFoundException e) {
                logger.log("WSSR0010", new Object[]{this.beanClass.getName(), constructor});
            }
        }
    }

    protected void setUpMethodParameterNamesCache() {
        this.methodParameterNamesCache = new HashMap();
        ClassPool pool = ClassPoolUtil.getClassPool(this.beanClass);
        Iterator it = this.methodsCache.values().iterator();
        while (it.hasNext()) {
            Method[] methods = (Method[])it.next();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.getParameterTypes().length == 0) {
                    this.methodParameterNamesCache.put(methods[i], EMPTY_STRING_ARRAY);
                    continue;
                }
                CtClass clazz = ClassPoolUtil.toCtClass(pool, method.getDeclaringClass());
                CtClass[] parameterTypes = ClassPoolUtil.toCtClassArray(pool, method.getParameterTypes());
                try {
                    String[] names = this.getParameterNames(clazz, (CtBehavior)clazz.getDeclaredMethod(method.getName(), parameterTypes));
                    this.methodParameterNamesCache.put(methods[i], names);
                    continue;
                }
                catch (NotFoundException e) {
                    logger.log("WSSR0011", new Object[]{this.beanClass.getName(), method});
                }
            }
        }
    }

    protected String[] getParameterNames(CtClass clazz, CtBehavior behavior) throws NotFoundException {
        MethodInfo methodInfo = behavior.getMethodInfo();
        CodeAttribute codeAttribute = (CodeAttribute)methodInfo.getAttribute("Code");
        if (codeAttribute == null) {
            return null;
        }
        LocalVariableAttribute lva = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        if (lva == null) {
            return null;
        }
        return this.toStringArray(behavior, lva);
    }

    protected String[] toStringArray(CtBehavior behavior, LocalVariableAttribute lva) throws NotFoundException {
        String[] names = new String[behavior.getParameterTypes().length];
        int offset = Modifier.isStatic((int)behavior.getModifiers()) ? 0 : 1;
        for (int i = 0; i < names.length; ++i) {
            names[i] = lva.variableName(i + offset);
        }
        return names;
    }

    private Constructor findSuitableConstructor(Object[] args) {
        block0: for (int i = 0; i < this.constructors.length; ++i) {
            Class<?>[] paramTypes = this.constructors[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !ClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass())) continue block0;
            }
            return this.constructors[i];
        }
        return null;
    }

    private Constructor findSuitableConstructorAdjustNumber(Object[] args) {
        block0: for (int i = 0; i < this.constructors.length; ++i) {
            Class[] paramTypes = this.constructors[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !ClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass()) && !BeanDescImpl.adjustNumber(paramTypes, args, j)) continue block0;
            }
            return this.constructors[i];
        }
        return null;
    }

    private static boolean adjustNumber(Class[] paramTypes, Object[] args, int index) {
        if (paramTypes[index].isPrimitive()) {
            if (paramTypes[index] == Integer.TYPE) {
                args[index] = IntegerConversionUtil.toInteger(args[index]);
                return true;
            }
            if (paramTypes[index] == Double.TYPE) {
                args[index] = DoubleConversionUtil.toDouble(args[index]);
                return true;
            }
            if (paramTypes[index] == Long.TYPE) {
                args[index] = LongConversionUtil.toLong(args[index]);
                return true;
            }
            if (paramTypes[index] == Short.TYPE) {
                args[index] = ShortConversionUtil.toShort(args[index]);
                return true;
            }
            if (paramTypes[index] == Float.TYPE) {
                args[index] = FloatConversionUtil.toFloat(args[index]);
                return true;
            }
        } else {
            if (paramTypes[index] == (class$java$lang$Integer == null ? (class$java$lang$Integer = BeanDescImpl.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                args[index] = IntegerConversionUtil.toInteger(args[index]);
                return true;
            }
            if (paramTypes[index] == (class$java$lang$Double == null ? (class$java$lang$Double = BeanDescImpl.class$("java.lang.Double")) : class$java$lang$Double)) {
                args[index] = DoubleConversionUtil.toDouble(args[index]);
                return true;
            }
            if (paramTypes[index] == (class$java$lang$Long == null ? (class$java$lang$Long = BeanDescImpl.class$("java.lang.Long")) : class$java$lang$Long)) {
                args[index] = LongConversionUtil.toLong(args[index]);
                return true;
            }
            if (paramTypes[index] == (class$java$lang$Short == null ? (class$java$lang$Short = BeanDescImpl.class$("java.lang.Short")) : class$java$lang$Short)) {
                args[index] = ShortConversionUtil.toShort(args[index]);
                return true;
            }
            if (paramTypes[index] == (class$java$lang$Float == null ? (class$java$lang$Float = BeanDescImpl.class$("java.lang.Float")) : class$java$lang$Float)) {
                args[index] = FloatConversionUtil.toFloat(args[index]);
                return true;
            }
        }
        return false;
    }

    private void setupPropertyDescs() {
        Method[] methods = this.beanClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            Method m = methods[i];
            String methodName = m.getName();
            if (methodName.startsWith("get")) {
                if (m.getParameterTypes().length != 0 || methodName.equals("getClass")) continue;
                propertyName = BeanDescImpl.decapitalizePropertyName(methodName.substring(3));
                this.setupReadMethod(m, propertyName);
                continue;
            }
            if (methodName.startsWith("is")) {
                if (m.getParameterTypes().length != 0 || !m.getReturnType().equals(Boolean.TYPE)) continue;
                propertyName = BeanDescImpl.decapitalizePropertyName(methodName.substring(2));
                this.setupReadMethod(m, propertyName);
                continue;
            }
            if (!methodName.startsWith("set") || m.getParameterTypes().length != 1 || methodName.equals("setClass")) continue;
            propertyName = BeanDescImpl.decapitalizePropertyName(methodName.substring(3));
            this.setupWriteMethod(m, propertyName);
        }
        Iterator i = this.invalidPropertyNames.iterator();
        while (i.hasNext()) {
            this.propertyDescCache.remove(i.next());
        }
        this.invalidPropertyNames.clear();
    }

    private static String decapitalizePropertyName(String name) {
        if (StringUtil.isEmpty(name)) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private void addPropertyDesc(PropertyDesc propertyDesc) throws EmptyRuntimeException {
        if (propertyDesc == null) {
            throw new EmptyRuntimeException("propertyDesc");
        }
        this.propertyDescCache.put(propertyDesc.getPropertyName(), propertyDesc);
    }

    private void setupReadMethod(Method readMethod, String propertyName) {
        Class<?> propertyType = readMethod.getReturnType();
        PropertyDesc propDesc = this.getPropertyDesc0(propertyName);
        if (propDesc != null) {
            if (!propDesc.getPropertyType().equals(propertyType)) {
                this.invalidPropertyNames.add(propertyName);
            } else {
                propDesc.setReadMethod(readMethod);
            }
        } else {
            propDesc = new PropertyDescImpl(propertyName, propertyType, readMethod, null, this);
            this.addPropertyDesc(propDesc);
        }
    }

    private void setupWriteMethod(Method writeMethod, String propertyName) {
        Class<?> propertyType = writeMethod.getParameterTypes()[0];
        PropertyDesc propDesc = this.getPropertyDesc0(propertyName);
        if (propDesc != null) {
            if (!propDesc.getPropertyType().equals(propertyType)) {
                this.invalidPropertyNames.add(propertyName);
            } else {
                propDesc.setWriteMethod(writeMethod);
            }
        } else {
            propDesc = new PropertyDescImpl(propertyName, propertyType, null, writeMethod, this);
            this.addPropertyDesc(propDesc);
        }
    }

    private Method getSuitableMethod(String methodName, Object[] args) throws MethodNotFoundRuntimeException {
        Method[] methods;
        Method method;
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if ((method = this.findSuitableMethod(methods = this.getMethods(methodName), args)) != null) {
            return method;
        }
        method = this.findSuitableMethodAdjustNumber(methods, args);
        if (method != null) {
            return method;
        }
        throw new MethodNotFoundRuntimeException(this.beanClass, methodName, args);
    }

    private Method findSuitableMethod(Method[] methods, Object[] args) {
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !ClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass())) continue block0;
            }
            return methods[i];
        }
        return null;
    }

    private Method findSuitableMethodAdjustNumber(Method[] methods, Object[] args) {
        block0: for (int i = 0; i < methods.length; ++i) {
            Class[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !ClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass()) && !BeanDescImpl.adjustNumber(paramTypes, args, j)) continue block0;
            }
            return methods[i];
        }
        return null;
    }

    private void setupMethods() {
        int i;
        ArrayMap methodListMap = new ArrayMap();
        Method[] methods = this.beanClass.getMethods();
        for (i = 0; i < methods.length; ++i) {
            ArrayList<Method> list = (ArrayList<Method>)methodListMap.get(methods[i].getName());
            if (list == null) {
                list = new ArrayList<Method>();
                methodListMap.put(methods[i].getName(), list);
            }
            list.add(methods[i]);
        }
        for (i = 0; i < methodListMap.size(); ++i) {
            List methodList = (List)methodListMap.get(i);
            this.methodsCache.put(methodListMap.getKey(i), methodList.toArray(new Method[methodList.size()]));
        }
    }

    private void setupFields() {
        this.setupFields(this.beanClass);
    }

    private void setupFields(Class targetClass) {
        if (targetClass.isInterface()) {
            this.setupFieldsByInterface(targetClass);
        } else {
            this.setupFieldsByClass(targetClass);
        }
    }

    private void setupFieldsByInterface(Class interfaceClass) {
        this.addFields(interfaceClass);
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.setupFieldsByInterface(interfaces[i]);
        }
    }

    private void addFields(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String fname = field.getName();
            if (this.fieldCache.containsKey(fname)) continue;
            ((AccessibleObject)field).setAccessible(true);
            this.fieldCache.put(fname, field);
        }
    }

    private void setupFieldsByClass(Class targetClass) {
        this.addFields(targetClass);
        Class<?>[] interfaces = targetClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.setupFieldsByInterface(interfaces[i]);
        }
        Class superClass = targetClass.getSuperclass();
        if (superClass != (class$java$lang$Object == null ? (class$java$lang$Object = BeanDescImpl.class$("java.lang.Object")) : class$java$lang$Object) && superClass != null) {
            this.setupFieldsByClass(superClass);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

