/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import org.seasar.framework.exception.SIllegalStateException;
import org.seasar.framework.util.ResourceUtil;

public final class EclipseUtil {
    private EclipseUtil() {
    }

    public static File getProjectRoot(String projectName) {
        File from;
        for (File dir = from = ResourceUtil.getResourceAsFile("."); dir != null; dir = dir.getParentFile()) {
            if (dir.getName().equalsIgnoreCase(projectName)) {
                return dir;
            }
            File child = new File(dir, projectName);
            if (!child.exists()) continue;
            return child;
        }
        throw new SIllegalStateException("ESSR0004", new Object[]{projectName, from.getAbsolutePath()});
    }

    public static File getCurrentProjectRoot() {
        File from;
        for (File dir = from = ResourceUtil.getResourceAsFile("."); dir != null; dir = dir.getParentFile()) {
            File projectFile = new File(dir, ".project");
            if (!projectFile.exists()) continue;
            return dir;
        }
        throw new SIllegalStateException("ESSR0004", new Object[]{".project", from.getAbsolutePath()});
    }
}

