#!/bin/sh

# ------------- check Java Home --------------------------------------

if [ -z "$JAVA_HOME" ] ;  then
  echo "You must set JAVA_HOME to point at your Java Development Kit installation"
  exit 1
fi

# ------------- set GPSS Option ------------------------------------
GPSS_OPT=""

if [ -d ${JAVA_HOME}/jre ] ; then
  __SERVER_JVM_PATH=${JAVA_HOME}/jre/lib/i386/server
else
  __SERVER_JVM_PATH=${JAVA_HOME}/lib/i386/server
fi

if [ -d ${__SERVER_JVM_PATH} ] ; then
  GPSS_OPT="$GPSS_OPT -server"
  echo "Use Java HotSpot Server VM"
else
  echo "Use Java HotSpot Client VM"
fi

# ------------- set classpath --------------------------------------
GPSS_CP=$CLASSPATH

GPSS_CP=$GPSS_CP:./classes

GPSS_CP=$GPSS_CP:./bootstrap.jar
GPSS_CP=$GPSS_CP:./lib/g2-framework.jar
GPSS_CP=$GPSS_CP:./lib/g2-extention.jar

GPSS_CP=$GPSS_CP:./lib/s2-framework-2.3.7-20060407.jar
GPSS_CP=$GPSS_CP:./lib/s2-extension-2.3.7.jar
GPSS_CP=$GPSS_CP:./lib/s2-tiger-2.3.4.jar

GPSS_CP=$GPSS_CP:./lib/aopalliance-1.0.jar
GPSS_CP=$GPSS_CP:./lib/commons-logging-1.0.4.jar
GPSS_CP=$GPSS_CP:./lib/concurrent.jar
GPSS_CP=$GPSS_CP:./lib/geronimo-spec-j2ee-1.4-rc4.jar
GPSS_CP=$GPSS_CP:./lib/javassist-3.0.jar
GPSS_CP=$GPSS_CP:./lib/junit-3.8.1.jar
GPSS_CP=$GPSS_CP:./lib/log4j-1.2.8.jar
GPSS_CP=$GPSS_CP:./lib/ognl-2.6.5.jar
GPSS_CP=$GPSS_CP:./lib/poi-2.5.1-final-20040804.jar

${JAVA_HOME}/bin/java ${GPSS_OPT} -cp "${GPSS_CP}" jp.wda.g2.standalone.Bootstrap $@
