/* *****************************************************************************
 * 
 * Copyright(C) The GPSS Project Team and the Others. All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * ***************************************************************************** */
package jp.wda.g2.system;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;

import jp.wda.g2.ConnectingConditions;
import jp.wda.g2.Connection;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.exception.GPSSException;
import jp.wda.gpss.util.Logger;
import jp.wda.gpss.util.PseudoUUID;


/**
 * 
 * 
 * <div style="font-weight:bold; font-size:10.5pt;">
 * [ύX]
 * </div><dl style="margin:0px; border:1px solid #eee; padding:10px; font-size:10pt;">
 * 
 * <dt> 2.0.0-a1 </dt><dd> 2006/02/23 16:00:00  </dd>
 * 
 * </dl>
 * @version	2.0.0-a1
 * @since		2.0.0-a1
 * 
 * @author		A M O I
 */
public abstract class AbstractSocketProcessor implements SocketProcessor {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/**
	 * ftHg̐ݒpăIuWFNg\zRXgN^
	 * 
	 */
	public AbstractSocketProcessor(Connection connection, SockletContainer container) throws GPSSException {
		super();
		
		this.connection = connection;
		if(connection != null){
			this.ipAddress = connection.getSocketChannel().socket().getInetAddress().getHostAddress();
		}
		try{
			this.clientID = new PseudoUUID(ipAddress).toString();
		}catch(IOException ex){ throw new GPSSException(); }
		
		this.linkage = new SockletLinkage(this, container);
		terminated = false;
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/** VXeK[ */
	protected final Logger syslog = Logger.getLogger(GPSSConstants.SYSTEMLOG_CATEGORY);

	/** XXX */
	private SockletLinkage linkage = null;
	
	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */
	/** XXX */
	private Connection connection = null;
	/**
	 * XXX擾܂B<BR>
	 * @return XXX
	 */
	public Connection getConnection(){ return connection; }

	/* ***********************************************************************>> */;
	/**
	 *	NCAgID<BR>
	 */
	private String clientID;
	/**
	 *	NCAgID擾܂B<BR>
	 *	@return NCAgID
	 *	@see jp.wda.g2.SocketProcessor#getClientID()
	 */
	public String getClientID(){ return clientID; }

	/* ***********************************************************************>> */
	/** NCAg̃zXgIPAhX */
	private String ipAddress = null;
	/**
	 * NCAg̃zXgIPAhX擾܂B<BR>
	 * @return NCAg̃zXgIPAhX
	 * @see jp.wda.g2.SocketProcessor#getIPAddress()
	 */
	public String getIPAddress(){ return ipAddress; }

	/* ***********************************************************************>> */;
	/**
	 * ftHg̃GR[fBO<BR>
	 */
	private String encoding = "UTF-8";
	/**
	 *	gpftHg̃GR[fBO擾܂B<BR>
	 *	@return ftHg̃GR[fBO
	 *	@see jp.wda.g2.SocketProcessor#getEncoding()
	 */
	public String getEncoding(){ return encoding; }
	/**
	 *	gpftHg̃GR[fBOݒ肵܂B<BR>
	 *	@param s ݒl<BR>
	 */
	public void setEncoding(String s){ encoding = s; }

	/* ***********************************************************************>> */
	/** ^CAEg~b */
	private long timeout = 0;
	/**
	 * ^CAEg~b擾܂B<BR>
	 * @return ^CAEg~b
	 */
	public long getTimeout(){ return timeout; }
	/**
	 * ^CAEg~bݒ肵܂B<BR>
	 * @param s ݒl<BR>
	 */
	public void setTimeout(long s){ timeout = s; }

	/* ***********************************************************************>> */
	/** Iς݃\Pbgł邩ǂ */
	private boolean terminated = false;
	/**
	 * Iς݃\Pbgł邩ǂ擾܂B<BR>
	 * @return Iς݃\PbgłȂ^
	 */
	public boolean isTerminated(){ return terminated; }

	/* ***********************************************************************>> */
	/** XXX */
	private Object attributes = null;
	/**
	 * XXX擾܂B<BR>
	 * @return XXX
	 */
	public Object getAttributes(){ return attributes; }
	/**
	 * XXXݒ肵܂B<BR>
	 * @param s ݒl<BR>
	 */
	public void setAttributes(Object s){ attributes = s; }

	/* ***********************************************************************>> */
	/** XXX */
	private ConnectingConditions connectingConditions = null;
	/**
	 * XXX擾܂B<BR>
	 * @return XXX
	 */
	public ConnectingConditions getConnectingConditions(){ return connectingConditions; }
	/**
	 * XXXݒ肵܂B<BR>
	 * @param s ݒl<BR>
	 */
	public void setConnectingConditions(ConnectingConditions s){
		if(connectingConditions != null){ return; }
		connectingConditions = s;
	}
	
	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * 
	 * @param command 
	 */
	public void doCommand(ByteBuffer command){
		try{
			linkage.doCommand(command);
		}catch(GPSSException ex){
			syslog.errormessage(ex);
			terminate();
		}catch(UndeclaredThrowableException ex){
			Throwable th = ex.getUndeclaredThrowable();
			if(th instanceof InvocationTargetException){
				th = ((InvocationTargetException)th).getTargetException();
				if(th instanceof GPSSException){
					syslog.errormessage((GPSSException)th);
					terminate();
					return;
				}
			}
			syslog.errormessage("EGSS50001", new Object[]{ getClientID(), command }, ex);
		}catch(Throwable ex){
			syslog.errormessage("EGSS50001", new Object[]{ getClientID(), command }, ex);
		}
	}
	
	/**
	 * 
	 */
	public void terminate(){
		synchronized (this) {
			if (this.terminated) {
				return;
			}
			this.terminated = true;
		}
		
		linkage.removeClient(true);
		getConnection().closeConnection();
	}

}
