/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.extention.socklet;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jp.wda.g2.GeneralSocklet;
import jp.wda.g2.SockletRequest;
import jp.wda.g2.exception.CommandParseException;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.extention.socklet.CommandRequest;
import jp.wda.g2.extention.socklet.CommandRequestImpl;
import jp.wda.g2.extention.socklet.ICommandSocklet;

public abstract class CommandSocklet
extends GeneralSocklet
implements ICommandSocklet {
    private boolean execIgnoreCase = true;
    private ConcurrentMap<String, Method> methodsCache = new ConcurrentHashMap<String, Method>();

    public boolean isExecIgnoreCase() {
        return this.execIgnoreCase;
    }

    public void setExecIgnoreCase(boolean s) {
        this.execIgnoreCase = s;
    }

    public Object doCommand(SockletRequest req) throws GPSSException {
        CommandRequest request = new CommandRequestImpl(req);
        this.preProcess(request);
        request = this.parseCommand((CommandRequestImpl)request);
        if (request.getName() == null || request.getName().length() == 0) {
            throw new CommandParseException(request.getCommand());
        }
        return this.doCommandMethod(request);
    }

    public Object doCommandMethod(CommandRequest request) throws GPSSException {
        String methodname;
        Method method;
        String name = request.getName();
        if (this.execIgnoreCase) {
            name = String.valueOf(name.substring(0, 1).toUpperCase()) + (name.length() > 1 ? name.substring(1).toLowerCase() : "");
        }
        if ((method = (Method)this.methodsCache.get(methodname = request.toString())) == null) {
            try {
                method = this.getClass().getMethod("cmd" + name, request.getType());
                this.methodsCache.put(methodname, method);
            }
            catch (NoSuchMethodException e) {
                return this.cmdUndefined(request);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            return method.invoke((Object)this, request.getParams());
        }
        catch (Throwable e) {
            this.syslog.fatalmessage(e);
            throw new CommandParseException(request.getCommand());
        }
    }

    protected abstract CommandRequest parseCommand(CommandRequestImpl var1) throws GPSSException;

    public Object cmdUndefined(CommandRequest request) throws GPSSException {
        return request.handoverRequest();
    }

    public void preProcess(CommandRequest request) throws GPSSException {
    }
}

