/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.system;

import java.nio.ByteBuffer;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.Socklet;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.exception.SockletNotFoundException;
import jp.wda.g2.system.SockletContainer;

public class SockletLinkage {
    private SocketProcessor client = null;
    private SockletContainer container = null;
    private SockletLinkage next = null;
    private Object attributes = null;

    public SockletLinkage(SocketProcessor client, SockletContainer container) throws GPSSException {
        this.client = client;
        this.setContainer(container);
    }

    public SockletContainer getContainer() {
        return this.container;
    }

    private void setContainer(SockletContainer container) throws GPSSException {
        if (container == null || container.getSocklet() == null) {
            throw new SockletNotFoundException("");
        }
        this.container = container;
        container.accept(this.client, this);
    }

    public Socklet getSocklet() {
        if (this.container == null) {
            return null;
        }
        return this.container.getSocklet();
    }

    public SockletLinkage getNext() {
        return this.next;
    }

    private void setNext(SockletLinkage s) {
        this.next = s;
    }

    public void setNextSocklet(SockletContainer container, boolean removeChildren) throws GPSSException {
        if (container.getMainReactor() == null) {
            container.setMainReactor(this.container.getMainReactor());
        }
        SockletLinkage next = new SockletLinkage(this.client, container);
        SockletLinkage old = this.next;
        this.next = next;
        if (old == null) {
            return;
        }
        old.removeClient(removeChildren);
        if (old.hasNext() && !removeChildren) {
            next.setNext(old.getNext());
        }
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Object s) {
        this.attributes = s;
    }

    public Object doCommand(ByteBuffer command) throws GPSSException {
        if (this.container == null) {
            return null;
        }
        return this.container.doCommand(this.client, command, this);
    }

    void removeClient(boolean removeChildren) {
        this.container.desert(this.client, this);
        if (removeChildren && this.hasNext()) {
            this.next.removeClient(removeChildren);
        }
    }

    private void sendToClients(SocketProcessor[] clients, String message) {
        int i = 0;
        while (i < clients.length) {
            if (!clients[i].send(message)) {
                clients[i].terminate();
            }
            ++i;
        }
    }

    public final void sendToAllClients(String message) {
        this.sendToClients(this.container.getAllClients(), message);
    }
}

