/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.system;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.SockletRequest;
import jp.wda.g2.exception.CommandNotFoundException;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.system.SockletContainer;
import jp.wda.g2.system.SockletLinkage;

public class SockletRequestImpl
implements SockletRequest,
Serializable {
    private static final long serialVersionUID = -3465530253660016083L;
    private ByteBuffer rawCommand = null;
    private String command = null;
    private SocketProcessor client = null;
    private SockletLinkage linkage = null;
    private Object attribute = null;

    public SockletRequestImpl(SocketProcessor client, ByteBuffer rawCommand, SockletLinkage linkage) {
        this.client = client;
        this.rawCommand = rawCommand;
        this.linkage = linkage;
        if (rawCommand != null) {
            rawCommand.rewind();
            this.command = Charset.forName(client.getEncoding()).decode(rawCommand).toString();
        }
    }

    public SockletRequestImpl(SockletRequest request) {
        this(request.getClient(), request.getRawCommand(), request.getLinkage());
        this.setAttribute(request.getAttribute());
    }

    public ByteBuffer getRawCommand() {
        return this.rawCommand;
    }

    public String getCommand() {
        return this.command;
    }

    public SocketProcessor getClient() {
        return this.client;
    }

    public String getClientID() {
        return this.client.getClientID();
    }

    public SockletLinkage getLinkage() {
        return this.linkage;
    }

    protected void setLinkage(SockletLinkage s) {
        this.linkage = s;
    }

    public Object getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Object s) {
        this.attribute = s;
    }

    public void setNextSocklet(SockletContainer container, boolean removeChildren) throws GPSSException {
        this.getLinkage().setNextSocklet(container, removeChildren);
    }

    public Object handoverRequest() throws GPSSException {
        if (!this.getLinkage().hasNext()) {
            throw new CommandNotFoundException(this.command);
        }
        return this.getLinkage().getNext().doCommand(this.rawCommand);
    }

    public SocketProcessor[] getAllClients() {
        return this.getLinkage().getContainer().getAllClients();
    }

    public void sendToAllClients(String message) {
        this.linkage.sendToAllClients(message);
    }

    public void send(String message) {
        this.client.send(message);
    }
}

