/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.wda.g2.exception.GPSSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.message.MessageFormatter;

public final class Logger {
    private static Map<String, Logger> loggerMap = Collections.synchronizedMap(new HashMap());
    private Log log;

    private Logger(String name) {
        this.log = LogFactory.getLog((String)name);
    }

    public static final Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static final Logger getLogger(String name) {
        Logger logger = loggerMap.get(name);
        if (logger == null) {
            logger = new Logger(name);
            loggerMap.put(name, logger);
        }
        return logger;
    }

    public final boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public final boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public final void debug(Object message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.log.debug(message, throwable);
        }
    }

    public final void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.log.debug(message);
        }
    }

    public final void info(Object message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log.info(message, throwable);
        }
    }

    public final void info(Object message) {
        if (this.isInfoEnabled()) {
            this.log.info(message);
        }
    }

    public final void warn(Object message, Throwable throwable) {
        this.log.warn(message, throwable);
    }

    public final void warn(Object message) {
        this.log.warn(message);
    }

    public final void error(Object message, Throwable throwable) {
        this.log.error(message, throwable);
    }

    public final void error(Object message) {
        this.log.error(message);
    }

    public final void fatal(Object message, Throwable throwable) {
        this.log.fatal(message, throwable);
    }

    public final void fatal(Object message) {
        this.log.fatal(message);
    }

    public final void log(Throwable throwable) {
        this.error(throwable.getMessage(), throwable);
    }

    public final void log(String messageCode, Object[] args) {
        this.log(messageCode, args, null);
    }

    public final void log(String messageCode, Object[] args, Throwable throwable) {
        char messageType = messageCode.charAt(0);
        if (this.isEnabledFor(messageType)) {
            String message = MessageFormatter.getSimpleMessage((String)messageCode, (Object[])args);
            switch (messageType) {
                case 'D': {
                    this.log.debug((Object)message, throwable);
                    break;
                }
                case 'I': {
                    this.log.info((Object)message, throwable);
                    break;
                }
                case 'W': {
                    this.log.warn((Object)message, throwable);
                    break;
                }
                case 'E': {
                    this.log.error((Object)message, throwable);
                    break;
                }
                case 'F': {
                    this.log.fatal((Object)message, throwable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(messageType));
                }
            }
        }
    }

    private boolean isEnabledFor(char messageType) {
        switch (messageType) {
            case 'D': {
                return this.log.isDebugEnabled();
            }
            case 'I': {
                return this.log.isInfoEnabled();
            }
            case 'W': {
                return this.log.isWarnEnabled();
            }
            case 'E': {
                return this.log.isErrorEnabled();
            }
            case 'F': {
                return this.log.isFatalEnabled();
            }
        }
        throw new IllegalArgumentException(String.valueOf(messageType));
    }

    public final void infomessage(String messageCode) {
        if (this.isInfoEnabled()) {
            this.log.info((Object)MessageFormatter.getSimpleMessage((String)messageCode, null));
        }
    }

    public final void infomessage(String messageCode, Object[] args) {
        if (this.isInfoEnabled()) {
            this.log.info((Object)MessageFormatter.getSimpleMessage((String)messageCode, (Object[])args));
        }
    }

    public final void infomessage(String messageCode, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log.info((Object)MessageFormatter.getSimpleMessage((String)messageCode, null), throwable);
        }
    }

    public final void infomessage(String messageCode, Object[] args, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log.info((Object)MessageFormatter.getSimpleMessage((String)messageCode, (Object[])args), throwable);
        }
    }

    public final void errormessage(String messageCode) {
        this.log.error((Object)MessageFormatter.getMessage((String)messageCode, null));
    }

    public final void errormessage(String messageCode, Object[] args) {
        this.log.error((Object)MessageFormatter.getMessage((String)messageCode, (Object[])args));
    }

    public final void errormessage(String messageCode, Throwable throwable) {
        this.log.error((Object)MessageFormatter.getMessage((String)messageCode, null), throwable);
    }

    public final void errormessage(String messageCode, Object[] args, Throwable throwable) {
        this.log.error((Object)MessageFormatter.getMessage((String)messageCode, (Object[])args), throwable);
    }

    public final void errormessage(GPSSException exception) {
        this.log.error((Object)"", (Throwable)exception);
    }

    public final void fatalmessage(Throwable throwable) {
        this.log.fatal((Object)MessageFormatter.getMessage((String)"EGSS99999", null), throwable);
    }
}

