/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.lang.reflect.Method;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.IllegalInitMethodAnnotationRuntimeException;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.annotation.tiger.Aspect;
import org.seasar.framework.container.annotation.tiger.AutoBindingType;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.Component;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.framework.container.annotation.tiger.InstanceType;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.factory.ConstantAnnotationHandler;

public class TigerAnnotationHandler
extends ConstantAnnotationHandler {
    public ComponentDef createComponentDef(Class componentClass, InstanceDef defaultInstanceDef, AutoBindingDef defaultAutoBindingDef) {
        AutoBindingType autoBindingType;
        Class clazz = componentClass;
        Component component = clazz.getAnnotation(Component.class);
        if (component == null) {
            return super.createComponentDef(componentClass, defaultInstanceDef, defaultAutoBindingDef);
        }
        ComponentDef componentDef = this.createComponentDefInternal(componentClass, defaultInstanceDef, defaultAutoBindingDef);
        componentDef.setComponentName(component.name());
        InstanceType instanceType = component.instance();
        if (instanceType != null) {
            componentDef.setInstanceDef(InstanceDefFactory.getInstanceDef((String)instanceType.getName()));
        }
        if ((autoBindingType = component.autoBinding()) != null) {
            componentDef.setAutoBindingDef(AutoBindingDefFactory.getAutoBindingDef((String)autoBindingType.getName()));
        }
        return componentDef;
    }

    public PropertyDef createPropertyDef(BeanDesc beanDesc, PropertyDesc propertyDesc) {
        if (!propertyDesc.hasWriteMethod()) {
            return super.createPropertyDef(beanDesc, propertyDesc);
        }
        Method method = propertyDesc.getWriteMethod();
        Binding binding = method.getAnnotation(Binding.class);
        String propName = propertyDesc.getPropertyName();
        if (binding != null) {
            String bindingTypeName = binding.bindingType().getName();
            String expression = binding.value();
            return this.createPropertyDef(propName, expression, bindingTypeName);
        }
        return super.createPropertyDef(beanDesc, propertyDesc);
    }

    public void appendAspect(ComponentDef componentDef) {
        Method[] methods;
        Class clazz = componentDef.getComponentClass();
        Aspect aspect = clazz.getAnnotation(Aspect.class);
        if (aspect != null) {
            String interceptor = aspect.value();
            String pointcut = aspect.pointcut();
            this.appendAspect(componentDef, interceptor, pointcut);
        }
        for (Method method : methods = clazz.getMethods()) {
            Aspect mAspect = method.getAnnotation(Aspect.class);
            if (mAspect == null) continue;
            String interceptor = mAspect.value();
            this.appendAspect(componentDef, interceptor, method);
        }
        super.appendAspect(componentDef);
    }

    public void appendInitMethod(ComponentDef componentDef) {
        Method[] methods;
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        for (Method method : methods = componentClass.getMethods()) {
            InitMethod initMethod = method.getAnnotation(InitMethod.class);
            if (initMethod == null) continue;
            if (method.getParameterTypes().length != 0) {
                throw new IllegalInitMethodAnnotationRuntimeException(componentClass, method.getName());
            }
            if (!this.isInitMethodRegisterable(componentDef, method.getName())) continue;
            this.appendInitMethod(componentDef, method.getName());
        }
        super.appendInitMethod(componentDef);
    }
}

