package jp.wda.gpss;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Priority;

import jp.wda.gpss.system.AttributeContainer;
import jp.wda.gpss.system.ExecutableBase;
import jp.wda.gpss.system.InitParamContainer;
import jp.wda.gpss.system.Main;
import jp.wda.gpss.util.Finder;
import jp.wda.gpss.util.SocketProcessorFinder;

/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o
 * </B></I></FONT><BR>
 * ł{ISockletNX<BR>
 * <BR>
 * Socklet쐬ɂ́ÃNXĥAł{Iȕ@łB<BR>
 * ̃NXhč쐬SockletNXł́A
 * ܂Socklet̏[`Lq邽߂ɁAȉ̃\bĥǂ炩I[o[ChĂB
 * ̕Kv΁AI[o[ChKv͂܂B
 *  <BLOCKQUOTE>
 *    <FONT COLOR="#0000FF">protected <FONT COLOR="#993300">void</FONT></FONT> init()<BR>
 *    <FONT COLOR="#0000FF">protected <FONT COLOR="#993300">void</FONT></FONT> init(<FONT COLOR="#993300">List</FONT> linkedSocklets)<BR>
 *  </BLOCKQUOTE>
 * 
 * jp.wda.gpss.SockletC^[tF[X́Aȉ̃\bhKI[o[ChKv܂B<BR>
 *  <BLOCKQUOTE>
 *    <FONT COLOR="#0000FF">public</FONT> <FONT COLOR="#993300">boolean</FONT> doCommand(<FONT COLOR="#993300">SocketProcessor</FONT> client, <FONT COLOR="#993300">String</FONT> command)<BR>
 *  </BLOCKQUOTE>
 * <BR>
 * ܂AKvł΁ACӂňȉ̃\bhI[o[Chł܂B
 *  <BLOCKQUOTE>
 *    <FONT COLOR="#0000FF">public</FONT> <FONT COLOR="#993300">boolean</FONT> checkConnection(<FONT COLOR="#993300">SocketProcessor</FONT> client)<BR>
 *    <FONT COLOR="#0000FF">public</FONT> <FONT COLOR="#993300">void</FONT> preRemoveClient(<FONT COLOR="#993300">SocketProcessor</FONT> client)<BR>
 *    <FONT COLOR="#0000FF">public</FONT> <FONT COLOR="#993300">void</FONT> afterDeployedLinks(<FONT COLOR="#993300">Map</FONT> linkedSocklets)<BR>
 *    <FONT COLOR="#0000FF">public</FONT> <FONT COLOR="#993300">void</FONT> destroy()<BR>
 *  </BLOCKQUOTE>
 * e\bhɂẮAjp.wda.gpss.Socklet̃hLgQƂĂB
 * <BR>
 * ܂ASockletԘAgsȂꍇ́A
 *  <BLOCKQUOTE>
 *    <FONT COLOR="#0000FF">public <FONT COLOR="#993300">boolean</FONT></FONT> allowAccessFromOtherSocklet(<FONT COLOR="#993300">Socklet </FONT> from)<BR>
 *  </BLOCKQUOTE>
 * \bhI[o[ChAAg悤ƂĂSockletĂB
 * 
 * @version	1.00007	2003/06/08
 * @since		1.00007	2003/05/10
 * @author	amoi
 */
public abstract class GeneralSocklet implements Socklet, InitParamContainer, AttributeContainer {
	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * Sockletz
	 */
	private SockletDeployInfo info;

	/* ***********************************************************************>> */;
	/**
	 * ڑNCAgꗗ
	 */
	private ArrayList clients;
	
	/* ***********************************************************************>> */;
	/**
	 * \Pbg󋵐iǗIuWFNg
	 */
	protected Progress progress;
	/**
	 * ftHg̃K[
	 */
	private String defaultLogger = Progress.SYSTEM_LOGGER;

	/* ***********************************************************************>> */;
	/**
	 * SockletŗLꗗ<BR>
	 */
	private Hashtable attributes = new Hashtable();

	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	CT[o<BR>
	 */
	private ExecutableBase server;
	/**
	 * CT[o擾܂B<BR>
	 * ̃\bh́A007p~AnullԂ܂B
	 * @return R}h߃GW
	 * @deprecated
	 */
	public final ExecutableBase getMain(){
		return null;
	}
	/**
	 * CT[oݒ肵܂B<BR>
	 * @param server \PbgҎ󂯃CT[o
	 */
	public final void setMain(ExecutableBase server){
		if(server != null){
			this.server = server;
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * SockletzSocklet<BR>
	 */
	private String deployedby = Main.DEPLOY_BY_SYSTEM;
	/**
	 * SockletzSocklet擾܂B<BR>
	 * 
	 * @return Socklet
	 * @see jp.wda.gpss.Socklet#deployedBy()
	 */
	public final String deployedBy(){ return deployedby; }
	/**
	 * SockletzSockletݒ肵܂B<BR>
	 * 
	 * @return Socklet
	 * @see jp.wda.gpss.Socklet#deployedBy(ExecutableBase, String)
	 */
	public final void deployedBy(ExecutableBase server, String name){
		if(server != null && name != null){ deployedby = name; }
	}

	// Sockletz擾\bh //////////////////////////////////////////////////////
	//                           Methods for Getting this socklet deployed infomations //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * Socklet̔z擾܂B<BR>
	 * zƂ́AGPSSݒt@C<application>m[hɋLqꂽname̒lłB<BR>
	 * NCAǵÁhzh𗊂ɁASocklet܂B<BR>
	 * 
	 * @return Socklet
	 * @see jp.wda.gpss.Socklet#getName()
	 */
	public final String getName(){ return info.getName(); }

	/* ***********************************************************************>> */;
	/**
	 * ^CAEg(~bP)擾܂B<BR>
	 *
	 * @return ^CAEg(~bP)
	 * @see jp.wda.gpss.Socklet#getTimeout()
	 */
	public final int getTimeout(){ return info.getTimeout(); }
	/**
	 * ^CAEg(~bP)ݒ肵܂B<BR>
	 *
	 * @param timeout ݒ肷^CAEg(~bP)
	 * @see jp.wda.gpss.Socklet#setTimeout(int)
	 */
	public final void setTimeout(int timeout){ info.setTimeout(timeout); }
	
	/* ***********************************************************************>> */;
	/**
	 * Sockletɐݒ肳ĂAw肳ꂽOSockletp[^l1擾܂B<BR>
	 * Sockletp[^Ƃ́AGPSSݒt@C&lt;socklet&gt;m[h̎qm[h&lt;init-param&gt;ɐݒ肳ꂽlłB<BR>
	 * &lt;init-param&gt;m[hkeyp[^̖OAvaluep[^̒l\܂B<BR>
	 * w肳ꂽÕp[^݂ꍇ́Aԏ߂ɐݒ肳ꂽlԂ܂B<BR>
	 * 
	 * @param key 擾p[^̖O
	 * @return w肳ꂽȌp[^l
	 * @see GeneralSocklet#getInitParams(String key)
	 * @see GeneralSocklet#getInitParams()
	 * @see jp.wda.gpss.system.InitParamContainer#getInitParam(String)
	 */
	public final String getInitParam(String key){
		return info.getInitParam(key);
	}
	/**
	 * Sockletɐݒ肳ĂAw肳ꂽOSockletp[^lꗗXgƂĎ擾܂B<BR>
	 * 
	 * @param key 擾p[^̖O
	 * @return w肳ꂽȌp[^lꗗێList
	 * @see GeneralSocklet#getInitParam(String key)
	 * @see GeneralSocklet#getInitParams()
	 * @see jp.wda.gpss.system.InitParamContainer#getInitParam(String)
	 */
	public final List getInitParams(String key){
		return info.getInitParams(key);
	}
	/**
	 * Sockletɐݒ肳ĂAׂĂSockletp[^lꗗXgƂĎ擾܂B<BR>
	 * 
	 * @return SĂSockletp[^̒lꗗێList
	 * @see GeneralSocklet#getInitParams(String key)
	 * @see GeneralSocklet#getInitParam(String key)
	 * @see jp.wda.gpss.system.InitParamContainer#getInitParams()
	 */
	public List getInitParams(){
		return info.getInitParams();
	}
	/**
	 * Sockletɐݒ肳ĂAׂĂSockletp[^̖OꗗXgƂĎ擾܂B
	 * @return SĂSockletp[^̖OꗗێList
	 * @see jp.wda.gpss.system.InitParamContainer#getInitParamKeys()
	 */
	public List getInitParamKeys(){
		return info.getInitParamKeys();
	}

	/* ***********************************************************************>> */;
	/**
	 * w肳ꂽp^̒lݒ肳Ă邩mF܂B<BR>
	 * @param key p^<BR>
	 * @return w肳ꂽȌp[^ݒ肳Ăꍇ͐^
	 * @see jp.wda.gpss.system.InitParamContainer#hasInitParam(String)
	 */
	public boolean hasInitParam(String key){
		return info.hasInitParam(key);
	}

	/* ***********************************************************************>> */;
	/**
	 * SockletɁAw肳ꂽOSockletŗLlݒ肵܂<BR>
	 * @param key SockletŗL<BR>
	 * @param value SockletŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, Object)
	 */
	public final void setAttribute(Object key, Object value){
		attributes.put(key, value);
	}
	/**
	 * Sockletɐݒ肳ĂAw肳ꂽOSockletŗLl擾܂B<BR>
	 * @param key SockletŗL
	 * @return SockletŗLl
	 * @see jp.wda.gpss.system.AttributeContainer#getAttribute(Object)
	 */
	public final Object getAttribute(Object key){ return attributes.get(key); }
	/**
	 * SockletŗLɊi[ĂSĂ̑ꗗSetr[擾܂B<BR>
	 * @return ꗗSetr[<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributes()
	 */
	public Set getAttributes(){
		return attributes.entrySet();
	}
	/**
	 * w肳ꂽSockletŗLݒ肳Ă邩mF܂B<BR>
	 * @param key SockletŗL<BR>
	 * @return w肳ꂽݒ肳Ăΐ^<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#containsAttributeKey(Object)
	 */
	public boolean containsAttributeKey(Object key){
		return attributes.containsKey(key);
	}
	/**
	 * SockletŗLɊi[Ă鑮ꗗSetr[擾܂B<BR>
	 * @return ꗗSetr[<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeKeys()
	 */
	public Set getAttributeKeys(){
		return attributes.keySet();
	}
	/**
	 * w肳ꂽSockletŗL폜܂B<BR>
	 * @param key SockletŗL<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#removeAttribute(Object)
	 */
	public Object removeAttribute(Object key){ return attributes.remove(key); }
	
	/**
	 * SockletɁAw肳ꂽOSockletŗLlݒ肵܂<BR>
	 * @param key SockletŗL<BR>
	 * @param value SockletŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, int)
	 */
	public final void setAttribute(Object key, int value){
		attributes.put(key, new Integer(value));
	}
	/**
	 * Sockletɐݒ肳ĂAw肳ꂽOSockletŗLl𐮐lƂĎ擾܂B<BR>
	 * @param key SockletŗL
	 * @return SockletŗLl
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeInt(Object)
	 */
	public final int getAttributeInt(Object key) throws AttributeException{
		Object ret = attributes.get(key);
		if(ret instanceof Integer){ return ((Integer)ret).intValue(); }
		throw new AttributeException("w肳ꂽ(" + key + ")int^ł͂܂B");
	}
	/**
	 * SockletɁAw肳ꂽOSockletŗLl𒷐lƂĐݒ肵܂<BR>
	 * @param key SockletŗL<BR>
	 * @param value SockletŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, long)
	 */
	public final void setAttribute(Object key, long value){
		attributes.put(key, new Long(value));
	}
	/**
	 * Sockletɐݒ肳ĂAw肳ꂽOSockletŗLl𒷐lƂĎ擾܂B<BR>
	 * @param key SockletŗL
	 * @return SockletŗLl
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeLong(Object)
	 */
	public final long getAttributeLong(Object key) throws AttributeException{
		Object ret = attributes.get(key);
		if(ret instanceof Long){ return ((Long)ret).longValue(); }
		throw new AttributeException("w肳ꂽ(" + key + ")long^ł͂܂B");
	}
	/**
	 * SockletɁAw肳ꂽǑŗLllƂĐݒ肵܂<BR>
	 * @param key SockletŗL<BR>
	 * @param value SockletŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, double)
	 */
	public final void setAttribute(Object key, double value){
		attributes.put(key, new Double(value));
	}
	/**
	 * Sockletɐݒ肳ĂAw肳ꂽǑŗLllƂĎ擾܂B<BR>
	 * @param key SockletŗL
	 * @return SockletŗLl
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeLong(Object)
	 */
	public final double getAttributeDouble(Object key) throws AttributeException{
		Object ret = attributes.get(key);
		if(ret instanceof Double){ return ((Double)ret).doubleValue(); }
		throw new AttributeException("w肳ꂽ(" + key + ")double^ł͂܂B");
	}
	/**
	 * SockletɁAw肳ꂽOSockletŗLl^UlƂĐݒ肵܂<BR>
	 * @param key SockletŗL<BR>
	 * @param value SockletŗL^Ul<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, boolean)
	 */
	public final void setAttribute(Object key, boolean value){
		attributes.put(key, new Boolean(value));
	}
	/**
	 * Sockletɐݒ肳ĂAw肳ꂽOSockletŗLl^UlƂĎ擾܂B<BR>
	 * @param key SockletŗL
	 * @return SockletŗL^Ul
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeBoolean(Object)
	 */
	public final boolean getAttributeBoolean(Object key) throws AttributeException{
		Object ret = attributes.get(key);
		if(ret instanceof Boolean){ return ((Boolean)ret).booleanValue(); }
		throw new AttributeException("w肳ꂽ(" + key + ")boolean^ł͂܂B");
	}

	/* ***********************************************************************>> */;
	/**
	 * w肳ꂽzAVSockletzIuWFNg쐬܂B<BR>
	 * 쐬ꂽIuWFNgɂ́A݂Sockletp[^ׂĐݒ肵܂B
	 * 
	 * @param appname z
	 * @return VSockletzIuWFNg
	 */
	public SockletDeployInfo copyInfo(String appname, String classname){
		SockletDeployInfo newinfo = new SockletDeployInfo(appname);
		newinfo.setClassname(classname);
		this.info.copyInitParamsTo(newinfo);
		newinfo.setTimeout(this.info.getTimeout());
		
		return newinfo;
	}
	
	/* ***********************************************************************>> */;
	/**
	 * Sockletzw肵āÃ݂T[oɔzĂAʂSocklet擾܂B<BR>
	 * w肳ꂽzSocklet݂ȂꍇA
	 * SockletɃANZXۂꂽꍇ́AnullԂ܂B
	 * 
	 * @param appname Sockletz
	 * @return w肳ꂽzSocklet
	 */
	public final Socklet getOtherSocklet(String appname){
		if(this.server == null){ return null; }
		if(appname.equals(this.getName())){
			return null;
		}
		
		Socklet other = this.server.getSocklet(appname);
		if(!other.allowAccessFromOtherSocklet(this)){
			return null;
		}
		
		return other;
	}

	// bZ[WM\bh ///////////////////////////////////////////////////////////
	//                                                    Methods for Sending messages //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * Sockletɐڑ̑SẴNCAgɌāAbZ[W𑗐M܂B<BR>
	 * 
	 * @param sender bZ[W𑗐MĂNCAg
	 * @param message M郁bZ[W
	 * @see jp.wda.gpss.Socklet#sendToAllClients(String)
	 */
	public final synchronized void sendToAllClients(String message){
		sendToClients(new ArrayList(clients), message);
	}
	
	/**
	 * Sockletɐڑ̃NCAĝȀLNCAĝ݂ɌāAbZ[W𑗐M܂B<BR>
	 * Ⴆ΁Ã[U[w肵āÃ[U[݂̂ɑMꍇ́Aȉ̂悤ɂ܂B<BR>
	 * sendToClients("肽bZ[W", new SocketProcessorFinderByUsername("肽[U["));<BR>
	 * ܂Ã[Uɂ̂ݑ肽Ȃꍇ͈ȉ̂悤ɂ܂B<BR>
	 * sendToClients("肽bZ[W", new SocketProcessorFinderByUsername(false, "肽Ȃ[U["));<BR>
	 * 
	 * @param sender bZ[W𑗐MĂNCAg
	 * @param message M郁bZ[W
	 * @param finder MNCAgpIuWFNg
	 * @see jp.wda.gpss.util.SocketProcessorFinder#getFinder(String)
	 * @see jp.wda.gpss.Socklet#sendToClients(String, Finder)
	 */
	public final synchronized void sendToClients(String message, Finder finder){
		if(finder == null){ return; }
		sendToClients(finder.getList(clients), message);
	}
	
	/**
	 * Sockletɐڑ̃NCAĝȀLNCAĝ݂ɌāAbZ[W𑗐M܂B<BR>
	 * ̎w@́ASocketProcessorFinder#getFinder(String)B
	 * 
	 * @param sender bZ[W𑗐MĂNCAg
	 * @param message M郁bZ[W
	 * @param condition MNCAǧ
	 * @see jp.wda.gpss.util.SocketProcessorFinder#getFinder(String)
	 * @see jp.wda.gpss.Socklet#sendToClients(String, String)
	 */
	public final synchronized void sendToClients(String message, String condition){
		try{
			sendToClients(message, SocketProcessorFinder.getFinder(condition));
		}catch(Throwable e){
			log("Create Finder object failure...", e);
			log("Condition:" + condition, Progress.ERROR);
		}
	}

	// ڑNCAg상\bh ///////////////////////////////////////////////////
	//                                          Methods for Control connected clilents //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * w肵NCAgASocklet̐ڑNCAgꗗɒǉ܂B<BR>
	 *
	 * @param client ǉNCAg
	 * @see jp.wda.gpss.Socklet#addClient(SocketProcessor)
	 */
	public final synchronized void addClient(SocketProcessor client){
		clients.add(client);
	}
	/**
	 * w肵NCAgASocklet̐ڑNCAgꗗ폜܂B<BR>
	 * @param client 폜NCAg
	 * @see jp.wda.gpss.Socklet#removeClient(SocketProcessor)
	 */
	public final synchronized void removeClient(SocketProcessor client){
		clients.remove(client);
	}
	
	/**
	 * ݐڑ̃NCAg𐔂܂B<BR>
	 * @param client ݐڑ̃NCAg
	 * @see jp.wda.gpss.Socklet#countClients()
	 */
	public final int countClients(){
		return clients.size();
	}
	/**
	 *	w肵NCAgA݂Socklet̐ڑNCAgꗗɑ݂邩mF܂B<BR>
	 *	@param client mFNCAg\PbgIuWFNg
	 *	@return w肵NCAgA݂SockletɐڑȂ^
	 */
	public final synchronized boolean containsClient(SocketProcessor client){
		return clients.indexOf(client) >= 0;
	}
	/**
	 * Sockletɐڑ̑SẴNCAgꗗAXgƂĎ擾܂B<BR>
	 * @return ڑNCAgꗗێList
	 */
	public final List getAllClients(){ return new ArrayList(clients); }
	/**
	 * Sockletɐڑ̃NCAgꗗ̂A
	 * w肳ꂽLNCAgꗗAXgƂĎ擾܂B<BR>
	 * 
	 * @param finder NCAg\IuWFNg
	 * @return ɈvNCAgꗗێList
	 */
	public final synchronized List getClients(Finder finder){
		if(finder == null){ return new ArrayList(); }
		return finder.getList(clients);
	}
	/**
	 * Sockletɐڑ̃NCAgꗗ̂A
	 * w肳ꂽLNCAgꗗAXgƂĎ擾܂B<BR>
	 * ̎w@́ASocketProcessorFinder#getFinder(String)B
	 * 
	 * @param condition NCAg
	 * @return ɈvNCAgꗗێList
	 * @see jp.wda.gpss.util.SocketProcessorFinder#getFinder(String)
	 */
	public final synchronized List getClients(String condition){
		try{
			return SocketProcessorFinder.getFinder(condition).getList(clients);
		}catch(Throwable e){
			log("Create Finder object failure...", e);
			log("Condition:" + condition, Progress.ERROR);
			return new ArrayList();
		}
	}
	
	/* ***********************************************************************>> */;
	/**
	 * Sockletɐڑ̑SNCAgؒf܂B<BR>
	 * 
	 * @param message bZ[W
	 * @see jp.wda.gpss.Socklet#disconnectAllClients(String)
	 */
	public final synchronized void disconnectAllClients(String message){
		Iterator i = new ArrayList(clients).iterator();
		while(i.hasNext()){
			((SocketProcessor)i.next()).terminate(message);
		}
	}
	
	/* ***********************************************************************>> */;
	/**
	 * NCAgiwIuWFNg\z܂B<BR>
	 * xxgetClients(String condition)gpA
	 * Ũ\bhFinderIuWFNg쐬A
	 * getClients(Finder finder)\bhgp()ptH[}X͗ǂł傤B
	 * 
	 * @param condition NCAg
	 * @return NCAg\IuWFNg
	 */
	public final Finder preCreateFinder(String condition){
		try{
			return SocketProcessorFinder.getFinder(condition);
		}catch(Throwable e){
			log("Create Finder object failure...", e);
			log("Condition:" + condition, Progress.ERROR);
			return new SocketProcessorFinder();
		}
	}

	// Oo͗p\bh ///////////////////////////////////////////////////////////////
	//                                                         Methods for Output Logs //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * Sockletw胍Ot@CAꂪo^ĂȂꍇ̓VXeOt@CɁA
	 * 񃍃Oo͂܂B<BR>
	 * @param message o͂郍ObZ[W
	 */
	public void log(Object message){
		progress.log(this.defaultLogger, message);
	}
	/**
	 * Sockletw胍Ot@CAꂪo^ĂȂꍇ̓VXeOt@CɁA
	 * w肳ꂽނ̃Oo͂܂B<BR>
	 * @param message o͂郍ObZ[W
	 * @param priority O
	 */
	public void log(Object message, Priority priority){
		progress.log(this.defaultLogger, message, priority);
	}
	/**
	 * Sockletw胍Ot@CAꂪo^ĂȂꍇ̓VXeOt@CɁA
	 * G[Oo͂܂B<BR>
	 * @param message o͂郍ObZ[W
	 * @param throwable G[
	 */
	public void log(Object message, Throwable throwable){
		progress.log(this.defaultLogger, message, Priority.ERROR, throwable);
	}
	/**
	 * Sockletw胍Ot@CAꂪo^ĂȂꍇ̓VXeOt@CɁA
	 * w肳ꂽނ̃Oo͂܂B<BR>
	 * @param message o͂郍ObZ[W
	 * @param priority O
	 * @param throwable G[
	 * @see jp.wda.gpss.Socklet#log(Object, Priority, Throwable)
	 */
	public void log(Object message, Priority priority, Throwable throwable){
		progress.log(this.defaultLogger, message, priority, throwable);
	}
	/**
	 * Oo͂܂B<BR>
	 * @param logger o͐惍K[
	 * @param message o͂郍ObZ[W
	 * @see jp.wda.gpss.Progress#log(String, Object)
	 */
	public void memo(String logger, Object message){
		progress.log(logger, message);
	}
	/**
	 * Oo͂܂B<BR>
	 * @param logger o͐惍K[
	 * @param message o͂郍ObZ[W
	 * @param priority O
	 * @see jp.wda.gpss.Progress#log(String, Object, Priority)
	 */
	public void memo(String logger, Object message, Priority priority){
		progress.log(logger, message, priority);
	}
	/**
	 * Oo͂܂B<BR>
	 * @param logger o͐惍K[
	 * @param message o͂郍ObZ[W
	 * @param throwable G[
	 * @see jp.wda.gpss.Progress#log(String, Object, Throwable)
	 */
	public void memo(String logger, Object message, Throwable t){
		progress.log(logger, message, Priority.ERROR, t);
	}
	/**
	 * Oo͂܂B<BR>
	 * @param logger o͐惍K[
	 * @param message o͂郍ObZ[W
	 * @param priority O
	 * @param throwable G[
	 * @see jp.wda.gpss.Progress#log(String, Object, Priority, Throwable)
	 */
	public void memo(String logger, Object message, Priority priority, Throwable t){
		progress.log(logger, message, priority, t);
	}

	// pNXŃI[o[Ch郁\bh /////////////////////////////////////////
	//                                                            Methods for Override //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * Socklet܂B<BR>
	 * 
	 * @param info Sockletz
	 * @param links IɒǉzSockletSockletzIuWFNgݒ肷邽߂List
	 * @param progress \Pbg󋵐iǗIuWFNgB
	 * @see jp.wda.gpss.Socklet#init(SockletDeployInfo, List, Progress)
	 */
	public final void init(SockletDeployInfo info, List links, Progress progress){
		clients = new ArrayList();
		
		this.info = info;
		this.progress = progress;
		if(progress.contansLogger(getName())){
			this.defaultLogger = getName();
		}
		
		// qSockletNXB
		init(links);
	}

	/**
	 * Socklet邽߂̃\bhB<BR>
	 * ̃\bh́A\PbgҎ󂯃T[őNɁA1񂾂Ă΂܂B<BR>
	 * Socklet̏ƂKvȏꍇ́Ã\bhA܂init()I[o[ChA̒ɋLqĂB<BR>
	 * <BR>
	 * œnlinkedSockletsSockletzIuWFNgǉƁA̔zSockletNAT[oɎIɔz܂B<BR>
	 * SockletmŘAgē悤SockletVXe\zꍇ́A
	 * SockletzIuWFNg쐬AlinksXgɒǉĂB
	 * 
	 * @param links IɒǉzSockletꍇ́ASockletzIuWFNgListɒǉĂB
	 * @see GeneralSocklet#init()
	 */
	protected void init(List links){ 
		init();
	}

	/**
	 * Socklet邽߂̃\bhB<BR>
	 * ̃\bh́A\PbgҎ󂯃T[őNɁA1񂾂Ă΂܂B<BR>
	 * Socklet̏ƂKvȏꍇ́Ã\bhA܂init(List)I[o[ChA̒ɋLqĂB<BR>
	 * 
	 * @see GeneralSocklet#init(List)
	 */
	protected void init(){ return; }

	/**
	 * ̃\bhinit(SockletDeployInfo info, List links, Progress progress)ɂāA
	 * linksIuWFNgɐݒ肳ꂽǉzSockletzIAT[oɂN1񂾂Ă΂܂B<BR>
	 * T[oɂĒǉzꂽSocklet\ߎ擾Ăꍇ́A
	 * ̃\bhI[o[ChĂB
	 * 
	 * @param links IɒǉzꂽSocklet̂ASocklet̃ANZXꂽSockletꗗASockletzL[ƂĕێMapIuWFNg
	 * @see jp.wda.gpss.Socklet#afterDeployedLinks(Map)
	 */
	public void afterDeployedLinks(Map linkedSocklets){ return; }

	/* ***********************************************************************>> */;
	/**
	 * ڑpR}hMANCAǧs߂̃\bhB<BR>
	 * ̃\bh́AT[oVNCAg̐ڑmF_ŁA
	 * ̃NCAg邽߂ɌĂ΂܂B<BR>
	 * ڑNCAgɑ΂ԏ߂Ɉ񂾂Ă΂܂B<BR>
	 * ڑ݂ĂNCAǧ⏉sȂꍇ́Ã\bhI[o[ChĂB<BR>
	 * I[o[ChȂꍇ́Aɐ^Ԃ܂B<BR>
	 * 
	 * @param client ڑ݂ĂNCAg
	 * @return AIꍇ͋UB
	 * @see GeneralSocklet#checkConnection(SocketProcessor)
	 * @see jp.wda.gpss.SocketProcessor
	 */
	public boolean checkConnection(SocketProcessor client){
		return true;
	}

	/* ***********************************************************************>> */;
	/**
	 * NCAg폜OɌĂяo郁\bhB<BR>
	 * ڑ̃NCAgؒfÃAvP[V珜O钼OɌĂ΂܂B<BR>
	 * ڑNCAgɑ΂AIOɈ񂾂Ă΂܂B<BR>
	 * ̐ڑNCAgցÃNCAgؒfꂽƂʒm悤ȏꍇ́A
	 * ̃\bhI[o[ChĂB<BR>
	 *
	 * @param client ꂩ폜NCAg
	 * @see GeneralSocklet#preRemoveClient(SocketProcessor)
	 */
	public void preRemoveClient(SocketProcessor client){ return; }
	
	/* ***********************************************************************>> */;
	/**
	 * SockletT[rX~ۂɁAҎ󂯃CT[oɂČĂяo܂B<BR>
	 * Socklet̏IKvȏꍇ́Ã\bhI[o[ChĂB
	 * 
	 * @see jp.wda.gpss.Socklet#destroy()
	 */
	public void destroy(){ return; }
	
	/* ***********************************************************************>> */;
	/**
	 * Socklet̃ANZX邩ǂmF܂B<BR>
	 * ł́AɃANZX܂B<BR>
	 * SockletɂăANZXꍇ́Ã\bhI[o[ChĂB<BR>
	 * 
	 * @param from ANZX݂ĂASocklet
	 * @return Socklet̃ANZXꍇ͐^
	 * @see jp.wda.gpss.Socklet#allowAccessFromOtherSocklet(Socklet)
	 */
	public boolean allowAccessFromOtherSocklet(Socklet from){
		return false; 
	}

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * w肳ꂽNCAgꗗɌāAbZ[W𑗐M܂B<BR>
	 * 
	 * @param sender bZ[W𑗐MĂNCAg
	 * @param clients MNCAgꗗ
	 * @param message M郁bZ[W
	 */
	private void sendToClients(List clients, String message){
		Iterator i = clients.iterator();
		while(i.hasNext()){
			SocketProcessor client = (SocketProcessor)i.next();
			if(!client.send(message)){ client.terminate(); continue; }
//			try{ wait(1000); }catch(Throwable e){ ; }
		}
	}
}
