package jp.wda.gpss.system;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Set;

import jp.wda.gpss.Progress;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.AttributeException;
import jp.wda.gpss.util.PseudoUUID;

/**
 *	NCAg\PbgC^[tF[X̎pNX
 *
 * @version	1.00005	2003/05/27
 * @since		1.00004	2003/05/25
 * @author	amoi
 */
abstract class SocketProcessorBase extends InitParamContainerImpl implements SocketProcessor, java.io.Serializable  {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * CT[o\PbgȂǂw肵ăIuWFNg\z܂B
	 * @param server Ҏ󂯃CT[o
	 * @param encoding \Pbg̃GR[fBO
	 * @param buffersize bZ[WMpobt@TCY
	 * @param ipaddr NCAg̃zXgIPAhX
	 * @throws IOException NCAgID̐Ɏsꍇ
	 */
	public SocketProcessorBase(Main server, String encoding, int buffersize, String ipaddr) throws IOException{
		super();
		this.server = server;
		this.progress = server.getProgress();
		this.ipaddr = ipaddr;
		setClientID(new PseudoUUID(ipaddr).toString());
		setEncoding(encoding);
		setMessagesBufferSize(buffersize);
		
		attributes = new Hashtable();
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * Ҏ󂯃CT[o
	 */
	private Main server;

	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	NCAgID<BR>
	 */
	private String clientid;
	/**
	 *	NCAgID擾܂B<BR>
	 *	@return NCAgID
	 *	@see jp.wda.gpss.SocketProcessor#getClientID()
	 */
	public String getClientID(){ return clientid; }
	/**
	 *	NCAgIDݒ肵܂B<BR>
	 *	@param s ݒl<BR>
	 */
	private void setClientID(String s){ clientid = s; }

	/* ***********************************************************************>> */;
	/**
	 *	GR[fBO<BR>
	 */
	private String encoding;
	/**
	 *	gpGR[fBO擾܂B<BR>
	 *	@return GR[fBO
	 */
	public String getEncoding(){ return encoding; }
	/**
	 *	gpGR[fBOݒ肵܂B<BR>
	 *	@param s ݒl<BR>
	 *	@see jp.wda.gpss.SocketProcessor#setEncoding(String)
	 */
	private void setEncoding(String s){ encoding = s; }

	/* ***********************************************************************>> */;
	/**
	 *	[U[<BR>
	 */
	private String username;
	/**
	 * [U[擾܂B<BR>
	 * Ԃł́A[U[Ƃ͐ڑpR}h̓Ԗڂ̈œn镶킵܂B<BR>
	 * 
	 * @return [U[
	 * @see jp.wda.gpss.SocketProcessor#getUserName()
	 * @see jp.wda.gpss.system.Main#doInitialCommand(SocketProcessorImpl, String)
	 */
	public String getUserName(){ return username; }
	/**
	 * [U[ݒ肵܂B<BR>
	 * @param s ݒl<BR>
	 * @see jp.wda.gpss.SocketProcessor#setUserName(String)
	 */
	public void setUserName(String s){ username = s; }

	/* ***********************************************************************>> */;
	/**
	 * pX[h<BR>
	 */
	private String password;
	/**
	 * pX[h擾܂B<BR>
	 * Ԃł́ApX[hƂ͐ڑpR}h̎OԖڂ̈œn镶킵܂B<BR>
	 * 
	 * @return pX[h
	 * @see jp.wda.gpss.SocketProcessor#getPassword()
	 * @see jp.wda.gpss.system.Main#doInitialCommand(SocketProcessorImpl, String)
	 */
	public String getPassword(){ return password; }
	/**
	 * pX[hݒ肵܂B<BR>
	 * @param s ݒl<BR>
	 * @see jp.wda.gpss.SocketProcessor#setPassword(String)
	 */
	public void setPassword(String s){ password = s; }

	/* ***********************************************************************>> */;
	/**
	 * NCAg̃zXgIPAhX<BR>
	 */
	private String ipaddr;
	/**
	 * ̃\PbggpĂNCAg̃zXgIPAhX擾܂B<BR>
	 * @return IPAhX
	 * @see jp.wda.gpss.SocketProcessor#getIPAddress()
	 */
	public String getIPAddress(){ return ipaddr; }
	
	/* ***********************************************************************>> */;
	/**
	 * MpbZ[Wobt@TCY
	 */
	private int buffermax = 30;
	/**
	 * MpbZ[Wobt@TCYݒ肵܂B
	 * @param size obt@TCY
	 */
	public void setMessagesBufferSize(int size){
		buffermax = size;
	}
	int getMessagesBufferSize(){ return buffermax; }

	/* ***********************************************************************>> */;
	/**
	 * ̃NCAgSocklet<BR>
	 */
	private Socklet application = null;
	/**
	 * ̃NCAgSocklet擾܂B<BR>
	 * ̃NCAgSocklet́AڑpR}ḧԖڂ̈œn镶SockletzɂāA
	 * T[oɂIAݒ肳܂B<BR>
	 * 
	 * @return ̃NCAgSocklet
	 */
	Socklet getApplication(){ return application; }
	/**
	 * ̃NCAgSockletݒ肵܂B<BR>
	 * @param s ݒl<BR>
	 * @see jp.wda.gpss.system.Main#doInitialCommand(SocketProcessorBase, String)
	 */
	public void setApplication(Socklet s){ application = s; }
	
	/* ***********************************************************************>> */;
	/**
	 * NCAgŗLꗗ
	 */
	private Hashtable attributes = null;
	/**
	 * NCAgŗLݒ肵܂B<BR>
	 * @param key NCAgŗL<BR>
	 * @param value NCAgŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, Object)
	 */
	public void setAttribute(Object key, Object value){
		attributes.put(key, value);
	}
	/**
	 * w肳ꂽ̃NCAgŗL擾܂B<BR>
	 * @param key NCAgŗL<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#getAttribute(Object)
	 */
	public Object getAttribute(Object key){ return attributes.get(key); }
	/**
	 * NCAgŗLɊi[ĂSĂ̑ꗗSetr[擾܂B<BR>
	 * @return ꗗSetr[<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributes()
	 */
	public Set getAttributes(){
		return attributes.entrySet();
	}
	/**
	 * w肳ꂽ̃NCAgŗLݒ肳Ă邩mF܂B<BR>
	 * @param key NCAgŗL<BR>
	 * @return w肳ꂽݒ肳Ăΐ^<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#containsAttributeKey(Object)
	 */
	public boolean containsAttributeKey(Object key){
		return attributes.containsKey(key);
	}
	/**
	 * NCAgŗLɊi[Ă鑮ꗗSetr[擾܂B<BR>
	 * @return ꗗSetr[<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeKeys()
	 */
	public Set getAttributeKeys(){
		return attributes.keySet();
	}
	/**
	 * w肳ꂽ̃NCAgŗL폜܂B<BR>
	 * @param key NCAgŗL<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#removeAttribute(Object)
	 */
	public Object removeAttribute(Object key){ return attributes.remove(key); }
	
	/**
	 * ̃NCAgɁAw肳ꂽÕNCAgŗLlݒ肵܂<BR>
	 * @param key NCAgŗL<BR>
	 * @param value NCAgŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, int)
	 */
	public final void setAttribute(Object key, int value){
		attributes.put(key, new Integer(value));
	}
	/**
	 * ̃NCAgɐݒ肳ĂAw肳ꂽÕNCAgŗLl𐮐lƂĎ擾܂B<BR>
	 * @param key NCAgŗL
	 * @return NCAgŗLl
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeInt(Object)
	 */
	public final int getAttributeInt(Object key) throws AttributeException{
		Object ret = attributes.get(key);
		if(ret instanceof Integer){ return ((Integer)ret).intValue(); }
		throw new AttributeException("w肳ꂽ(" + key + ")int^ł͂܂B");
	}
	/**
	 * ̃NCAgɁAw肳ꂽÕNCAgŗLl𒷐lƂĐݒ肵܂<BR>
	 * @param key NCAgŗL<BR>
	 * @param value NCAgŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, long)
	 */
	public final void setAttribute(Object key, long value){
		attributes.put(key, new Long(value));
	}
	/**
	 * ̃NCAgɐݒ肳ĂAw肳ꂽÕNCAgŗLl𒷐lƂĎ擾܂B<BR>
	 * @param key NCAgŗL
	 * @return NCAgŗLl
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeLong(Object)
	 */
	public final long getAttributeLong(Object key) throws AttributeException{
		Object ret = attributes.get(key);
		if(ret instanceof Long){ return ((Long)ret).longValue(); }
		throw new AttributeException("w肳ꂽ(" + key + ")long^ł͂܂B");
	}
	/**
	 * ̃NCAgɁAw肳ꂽǑŗLllƂĐݒ肵܂<BR>
	 * @param key NCAgŗL<BR>
	 * @param value NCAgŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, double)
	 */
	public final void setAttribute(Object key, double value){
		attributes.put(key, new Double(value));
	}
	/**
	 * ̃NCAgɐݒ肳ĂAw肳ꂽǑŗLllƂĎ擾܂B<BR>
	 * @param key NCAgŗL
	 * @return NCAgŗLl
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeLong(Object)
	 */
	public final double getAttributeDouble(Object key) throws AttributeException{
		Object ret = attributes.get(key);
		if(ret instanceof Double){ return ((Double)ret).doubleValue(); }
		throw new AttributeException("w肳ꂽ(" + key + ")double^ł͂܂B");
	}
	/**
	 * ̃NCAgɁAw肳ꂽÕNCAgŗLl^UlƂĐݒ肵܂<BR>
	 * @param key NCAgŗL<BR>
	 * @param value NCAgŗL^Ul<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, boolean)
	 */
	public final void setAttribute(Object key, boolean value){
		attributes.put(key, new Boolean(value));
	}
	/**
	 * ̃NCAgɐݒ肳ĂAw肳ꂽÕNCAgŗLl^UlƂĎ擾܂B<BR>
	 * @param key NCAgŗL
	 * @return NCAgŗL^Ul
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeBoolean(Object)
	 */
	public final boolean getAttributeBoolean(Object key) throws AttributeException{
		Object ret = attributes.get(key);
		if(ret instanceof Boolean){ return ((Boolean)ret).booleanValue(); }
		throw new AttributeException("w肳ꂽ(" + key + ")boolean^ł͂܂B");
	}
	
	/* ***********************************************************************>> */;
	/**
	 * \Pbg󋵐iǗIuWFNg
	 */
	private Progress progress;
	/**
	 *	\Pbg󋵐iǗIuWFNg擾܂B<BR>
	 *	@return \Pbg󋵐iǗIuWFNg
	 */
	Progress getProgress(){ return progress; }

	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	p^ݒ肵܂B<BR>
	 *	@param keyvalue up^=lv`̕<BR>
	 *	@return ݒ肵l<BR>
	 */
	String addInitParam(String keyvalue){
		if(keyvalue == null || keyvalue.length() == 0){ return null; }
		
		int idx = keyvalue.indexOf("=");
		if(idx == 0){ return null; }
		
		String value = keyvalue.substring(idx + 1);
		addInitParam(keyvalue.substring(0, idx), value);
		
		return value;
	}
	
	/* ***********************************************************************>> */;
	/**
	 * NCAg\PbgIuWFNgMڑpR}hT[o֓nA
	 * NCAg\PbgIuWFNg܂B<BR>
	 * 
	 * @param command ڑpR}h
	 */
	void doInitialCommand(String command){
		this.server.doInitialCommand(this, command);
	}
	
	/* ***********************************************************************>> */;
	/**
	 * SystemCommandSockletɂ̃NCAg̏Sockleť݂̐lʒm܂B
	 */
	void notifyToSystemCommandSocklet(){
		this.server.notifyToSystemCommandSocklet(this.application);
	}
}
