package jp.wda.gpss.system;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

import jp.wda.gpss.*;
import jp.wda.gpss.util.Finder;
import jp.wda.gpss.util.FinderElement;

import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

/**
 * T[oݒNX<BR>
 * ̃NXł̓CT[o珉ݒt@C̈ʒu擾A
 * ̃t@CXMLt@CƂēǂݍ݁AT[ȍݒsȂ܂B
 *
 * @version	1.00002	2003/05/22
 * @since		1.00002	2003/04/30
 * @author	amoi
 */
public class Configuration {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ݒt@Cw肵ăIuWFNg\z܂B
	 * 
	 * @param configFile ݒt@C
	 */
	public Configuration(File configFile){
		super();
		
		this.configFile = configFile;
	}

	// JtB[h ///////////////////////////////////////////////////////////////////
	//                                                            Public Static Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ftHg̑Ҏ󂯃|[gԍ
	 */
	public static final int DEFAULT_PORT = 9090;
	/**
	 * ftHg̃\PbgGR[fBO
	 */
	public static final String DEFAULT_ENCODING = "UTF-8";

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * zSockletNXꗗ
	 */
	private ArrayList applications;

	/* ***********************************************************************>> */;
	/**
	 * XNvgSockletzꗗ
	 */
	private ArrayList scriptsinfo;
	/**
	 * XNvgSockletp[^ꗗ
	 */
	private Hashtable scriptparams = new Hashtable();
	
	/**
	 * ݒt@C
	 */
	private File configFile;

	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	҂|[gԍ<BR>
	 */
	private int port;
	/**
	 *	҂|[gԍ擾܂B<BR>
	 *	@return ҂|[gԍ
	 */
	public int getPort(){ return port; }
	/**
	 *	҂|[gԍݒ肵܂B<BR>
	 *	@param s ݒl<BR>
	 */
	private void setPort(int s){ port = s; }

	/* ***********************************************************************>> */;
	/**
	 *	̃T[oŎgp镶GR[fBO<BR>
	 */
	private String encoding;
	/**
	 *	GR[fBO擾܂B<BR>
	 *	@return GR[fBO
	 */
	public String getEncoding(){ return encoding; }
	/**
	 * GR[fBOݒ肵܂B<BR>
	 * @param s ݒl<BR>
	 */
	private void setEncoding(String s){
		encoding = s;
	}

	/* ***********************************************************************>> */;
	/**
	 *	ڑpR}h̃^CAEg<BR>
	 */
	private int timeout;
	/**
	 *	ڑpR}h̃^CAEg(~bP)擾܂B<BR>
	 *	@return ڑpR}h̃^CAEg(~bP)
	 */
	public int getTimeout(){ return timeout; }
	/**
	 *	ڑpR}h̃^CAEg(~bP)ݒ肵܂B<BR>
	 *	@param s ݒl<BR>
	 */
	private void setTimeout(int s){ timeout = s; }

	/* ***********************************************************************>> */;
	/**
	 * ftHgSockletgp邩ǂ<BR>
	 */
	private boolean useDefault;
	/**
	 * ftHgSockletgp邩ǂ܂B<BR>
	 * gpȂꍇ͋UԂ܂B<BR>
	 * @return ftHgSockletgp邩ǂ
	 */
	public boolean isUsingDefault(){ return useDefault; }

	/* ***********************************************************************>> */;
	/**
	 *	ftHgSockleto^Ă邩ǂ<BR>
	 */
	private boolean setdefault;
	/**
	 * ftHgSockleto^Ă邩ǂ܂B<BR>
	 * o^Ăꍇ͐^Ԃ܂B<BR>
	 *	@return ftHgSockleto^Ă邩
	 */
	public boolean setDefault(){ return setdefault; }

	/* ***********************************************************************>> */;
	/**
	 *	MpbZ[Wobt@TCY<BR>
	 */
	private int buffermax;
	/**
	 *	MpbZ[Wobt@TCY擾܂B<BR>
	 *	@return MpbZ[Wobt@TCY
	 */
	public int getMessagesBufferSize(){ return buffermax; }
	/**
	 *	MpbZ[Wobt@TCYݒ肵܂B<BR>
	 *	@param s ݒl<BR>
	 */
	private void setMessagesBufferSize(int s){ buffermax = s; }

	/* ***********************************************************************>> */;
	/**
	 *	VXeR}hSockletz<BR>
	 */
	private SockletDeployInfo syscomInfo = new SockletDeployInfo(Main.SYSTEM_APPLICATION_NAME);
	/**
	 *	VXeR}hSockletz擾܂B<BR>
	 *	@return VXeR}hSockletz
	 */
	public SockletDeployInfo getSyscomInfo(){ return syscomInfo; }

	/* ***********************************************************************>> */;
	/**
	 *	log4jvpeB<BR>
	 */
	private Properties logprops = new Properties();
	private ArrayList loggers   = new ArrayList();
	/**
	 *	log4jvpeB擾܂B<BR>
	 *	@return log4jvpeB
	 */
	public Properties getLogProperties(){ return logprops; }
	/**
	 *	log4jvpeBɐݒ肳ꂽK[ꗗ擾܂B<BR>
	 *	@return log4jvpeBɐݒ肳ꂽK[ꗗ
	 */
	public List getLoggerNames(){ return loggers; }

	/* ***********************************************************************>> */;
	/**
	 *	VXeK[o^Ă邩ǂ<BR>
	 */
	private boolean setsyslog;
	/**
	 * VXeK[o^Ă邩ǂ܂B<BR>
	 * o^Ăꍇ͐^Ԃ܂B<BR>
	 *	@return VXeK[o^Ă邩
	 */
	public boolean setSysLog(){ return setsyslog; }

	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * ̃IuWFNgAݒt@Cǂݍ݂܂B
	 * 
	 * @throws ConfigurationError
	 */
	public void loadConfig() throws ConfigurationError{
		this.applications = new ArrayList();
		this.scriptsinfo  = new ArrayList();
		this.setdefault   = false;
		this.setsyslog    = false;
		
		try{
			createDigester().parse(configFile);
		}catch(IOException e){
			throw new ConfigurationError("ݒt@C(" + configFile.getAbsolutePath() + ")ǍɗO܂B\r\n" + e.toString());
		}catch(SAXException e){
			throw new ConfigurationError("XMLsłB\r\n" + e.toString());
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * T[oVXeݒ肵܂B<BR>
	 * ̃\bhDigesterĂ΂邽߂̂̂łB<BR>
	 * 
	 * @param port Ҏ󂯃|[gԍ
	 * @param encoding \PbgGR[fBO
	 * @param buffersize bZ[Wobt@TCY
	 * @param timeout ڑpR}h̃^CAEg
	 */
	public void setSystemInfomation(String port, String encoding, String buffersize, String timeout, String usedef){
		int setport;
		try{
			setport = Integer.parseInt(port);
		}catch(Exception e){
			setport = 0;
		}
		if(setport < 1024){
			System.out.println("Port:" + port + " ͐ݒł܂B");
			System.out.println("ftHg̃|[gԍ(" + DEFAULT_PORT + ")gp܂B");
			setport = DEFAULT_PORT;
		}
		
		if(encoding == null || encoding.length() == 0){
			System.out.println("GR[fBOw肳Ă܂B");
			System.out.println("ftHg̃GR[fBOgp܂B");
			encoding = DEFAULT_ENCODING;
		}
		
		int bmax = 30;
		try{
			bmax = Integer.parseInt(buffersize);
		}catch(Throwable e){
			bmax = 30;
		}
		
		int tout = 0;
		try{
			tout = Integer.parseInt(timeout);
		}catch(Throwable e){
			tout = 0;
		}
		
		if(usedef != null && usedef.equalsIgnoreCase("invalidate")){
			this.useDefault = false;
		}else{
			this.useDefault = true;
		}
		
		setPort(setport);
		setEncoding(encoding);
		setMessagesBufferSize(bmax);
		setTimeout(tout);
	}
	
	public void addAllowSystemCommand(String addr){
		syscomInfo.addInitParam("allow", addr);
	}
	
	public void addLogProperty(String key, String value){
		this.logprops.setProperty("log4j." + key, value);
		if(key.length() > 8 && "logger".equals(key.substring(0, 6))){
			loggers.add(key.substring(7));
		}
	}
	
	public void addLogger(String name, String mode, String file, String encoding, String layoutPattern){
		String appender = name + "Appender";
		String appnederKey = "log4j.appender." + appender;
		
		loggers.add(name);
		
		this.logprops.setProperty("log4j.logger." + name, mode + "," + appender);
		this.logprops.setProperty(appnederKey, "org.apache.log4j.DailyRollingFileAppender");
		this.logprops.setProperty(appnederKey + ".File", file);
		this.logprops.setProperty(appnederKey + ".DatePattern", "'.'yyyy-MM-dd");
		this.logprops.setProperty(appnederKey + ".Encoding", encoding);
		this.logprops.setProperty(appnederKey + ".layout", "org.apache.log4j.PatternLayout");
		this.logprops.setProperty(appnederKey + ".layout.ConversionPattern", layoutPattern);
	}
	
	public void addSystemLogger(String mode, String file, String encoding, String layoutPattern){
		this.setsyslog = true;
		addLogger(Progress.SYSTEM_LOGGER, mode, file, encoding, layoutPattern);
	}

	/* ***********************************************************************>> */;
	/**
	 * XNvgSockletzݒ肵܂B<BR>
	 * ̃\bhDigesterĂ΂邽߂̂̂łB<BR>
	 * 
	 * @param ext XNvgt@Cgq
	 * @param enc XNvgt@CGR[fBO
	 * @param dir XNvgt@CzufBNg
	 * @param jsclass XNvgt@C߃GWAvP[VNX
	 */
	public void setScriptInfomation(String ext, String enc, String dir, String jsclass){
		ScriptInfo sinfo = new ScriptInfo();
		if(sinfo.setInfomation(ext, enc, dir, jsclass)){
			scriptsinfo.add(sinfo);
		}
	}
	/**
	 * XNvgSockletzꗗXgƂĎ擾܂B
	 * 
	 * @return XNvgSockletzꗗ
	 */
	public List getScriptInfomations(){
		return scriptsinfo;
	}
	
	/**
	 * w肳ꂽgq̃XNvgSockletzԂ܂B<BR>
	 * w肳ꂽgq̃XNvgSockletz񂪐ݒ肳ĂȂꍇ́AnullԂ܂B
	 * 
	 * @param extention gq
	 * @return w肳ꂽgq̃XNvgSockletz
	 */
	public ScriptInfo getScriptInfomation(String extention){
		return (ScriptInfo)new SInfoFinder(extention).get(scriptsinfo);
	}
	
	/* ***********************************************************************>> */;
	/**
	 * XNvgSocklet̏p[^ݒ肵܂B<BR>
	 * ̃\bhDigesterĂ΂邽߂̂̂łB<BR>
	 * 
	 * @param app p[^ݒ肷XNvgSockletz
	 * @param key p[^
	 * @param value ݒ肷鏉p[^l
	 */
	public void setScriptInitParam(String app, String key, String value){
		if(!scriptparams.containsKey(app)){
			scriptparams.put(app, new SockletDeployInfo(app));
		}
		SockletDeployInfo appinfo = (SockletDeployInfo)scriptparams.get(app);
		appinfo.addInitParam(key, value);
	}
	
	/**
	 * XNvgSockletzw肵āA
	 * p[^̐ݒ肳ꂽSockletzIuWFNg擾܂B<BR>
	 * p[^ݒ肳ĂȂꍇ́AVKSockletzIuWFNg擾܂B<BR>
	 * 
	 * @param name XNvgAvP[V
	 * @return AvP[VێIuWFNg
	 */
	public SockletDeployInfo getScriptApplicationInfo(String name){
		if(scriptparams.containsKey(name)){
			return (SockletDeployInfo)scriptparams.get(name);
		}
		return new SockletDeployInfo(name);
	}

	/* ***********************************************************************>> */;
	/**
	 * SockletzIuWFNgǉ܂B<BR>
	 * ̃\bhDigesterĂ΂邽߂̂̂łB<BR>
	 * 
	 * @param addr SockletzIuWFNg
	 */
	public void addApplication(SockletDeployInfo app){
		if(app.getClassname() == null || app.getClassname().length() == 0 || app.getName() == null || app.getName().length() == 0){
			return;
		}
		if(app.getName().equals(Main.DEFAULT_APPLICATION_NAME)){
			this.setdefault = true;
		}else if(app.getName().equals(Main.SYSTEM_APPLICATION_NAME)){
			System.out.println("zu" + Main.SYSTEM_APPLICATION_NAME + "vSocklet͔zł܂B");
			return;
		}else if(app.getName().equals(Main.DEPLOY_BY_SYSTEM)){
			System.out.println("zu" + Main.DEPLOY_BY_SYSTEM + "vSocklet͔zł܂B");
			return;
		}
		if(app.getLogFile() != null){
			addLogger(app.getName(), app.getLogMode(), app.getLogFile(), app.getLogEncoding(), app.getLogPattern());
		}
		applications.add(app);
	}
	
	/**
	 * SockletzꗗXgƂĎ擾܂B<BR>
	 * 
	 * @return Sockletzꗗ
	 */
	public List getInformations(){
		return applications;
	}
	
	/**
	 * w肳ꂽzSockletzԂ܂B<BR>
	 * w肳ꂽzSockletz񂪐ݒ肳ĂȂꍇ́AnullԂ܂B
	 * 
	 * @param name Sockletz
	 * @return w肳ꂽzSockletz
	 */
	public SockletDeployInfo getInformation(String name){
		return (SockletDeployInfo)new DInfoFinder(name).get(applications);
	}

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * XMLt@CǍ[ݒ肵
	 * commons DigesterIuWFNg쐬B
	 * 
	 * @return commons DigesterIuWFNg
	 */
	private Digester createDigester(){
		Digester digester = new Digester();
		digester.setValidating(false);
		digester.push(this);
			
		digester.addCallMethod("XMLServer/system", "setSystemInfomation", 5);
		 digester.addCallParam("XMLServer/system", 0, "port");
		 digester.addCallParam("XMLServer/system", 1, "encoding");
		 digester.addCallParam("XMLServer/system", 2, "buffersize");
		 digester.addCallParam("XMLServer/system", 3, "timeout");
		 digester.addCallParam("XMLServer/system", 4, "default");
			
		digester.addCallMethod("XMLServer/system/command", "addAllowSystemCommand", 1);
		 digester.addCallParam("XMLServer/system/command", 0, "allow");
			
		digester.addCallMethod("XMLServer/system/logger", "addSystemLogger", 4);
		 digester.addCallParam("XMLServer/system/logger", 0, "mode");
		 digester.addCallParam("XMLServer/system/logger", 1, "file");
		 digester.addCallParam("XMLServer/system/logger", 2, "encoding");
		 digester.addCallParam("XMLServer/system/logger", 3, "layoutPattern");
			
		digester.addCallMethod("XMLServer/log4j/property", "addLogProperty", 2);
		 digester.addCallParam("XMLServer/log4j/property", 0, "key");
		 digester.addCallParam("XMLServer/log4j/property", 1, "value");
			
		digester.addCallMethod("XMLServer/log4j/logger", "addLogger", 5);
		 digester.addCallParam("XMLServer/log4j/logger", 0, "name");
		 digester.addCallParam("XMLServer/log4j/logger", 1, "mode");
		 digester.addCallParam("XMLServer/log4j/logger", 2, "file");
		 digester.addCallParam("XMLServer/log4j/logger", 3, "encoding");
		 digester.addCallParam("XMLServer/log4j/logger", 4, "layoutPattern");
			
		digester.addCallMethod("XMLServer/script", "setScriptInfomation", 4);
		 digester.addCallParam("XMLServer/script", 0, "extention");
		 digester.addCallParam("XMLServer/script", 1, "encoding");
		 digester.addCallParam("XMLServer/script", 2, "dir");
		 digester.addCallParam("XMLServer/script", 3, "class");
			
		digester.addCallMethod("XMLServer/script/init-param", "setScriptInitParam", 3);
		 digester.addCallParam("XMLServer/script/init-param", 0, "application");
		 digester.addCallParam("XMLServer/script/init-param", 1, "key");
		 digester.addCallParam("XMLServer/script/init-param", 2, "value");


		digester.addObjectCreate("XMLServer/socklet", SockletDeployInfo.class);
		digester.addSetNext("XMLServer/socklet", "addApplication");
		
		digester.addCallMethod("XMLServer/socklet", "setInformation", 3);
		 digester.addCallParam("XMLServer/socklet", 0, "name");
		 digester.addCallParam("XMLServer/socklet", 1, "class");
		 digester.addCallParam("XMLServer/socklet", 2, "timeout");
		
		digester.addCallMethod("XMLServer/socklet/init-param", "addInitParam", 2);
		 digester.addCallParam("XMLServer/socklet/init-param", 0, "key");
		 digester.addCallParam("XMLServer/socklet/init-param", 1, "value");
			
		digester.addCallMethod("XMLServer/socklet/logger", "setLoggerInfo", 4);
		 digester.addCallParam("XMLServer/socklet/logger", 0, "mode");
		 digester.addCallParam("XMLServer/socklet/logger", 1, "file");
		 digester.addCallParam("XMLServer/socklet/logger", 2, "encoding");
		 digester.addCallParam("XMLServer/socklet/logger", 3, "layoutPattern");
		
		return digester;
	}

	// NX ///////////////////////////////////////////////////////////////////////
	//                                                                     Inner Class //
	/////////////////////////////////////////////////////////////////////////////////////
	/**
	 *	SockletOpNX
	 */
	private class DInfoFinder extends Finder{
		public DInfoFinder(String name){
			super();
			group.add(new DInfoFinderElement(true, name));
		}
		public Object getReturnValue(Object elem){ return elem; }
		
		private class DInfoFinderElement extends FinderElement{
			DInfoFinderElement(boolean not, String name){ super(not, name); }
			public Object getFindValue(Object elem){
				if(!(elem instanceof SockletDeployInfo)){
					return null;
				}
				return ((SockletDeployInfo)elem).getName();
			}
		}
	}
	/**
	 *	XNvgSockletzgqpNX
	 */
	private class SInfoFinder extends Finder{
		public SInfoFinder(String extention){
			super();
			group.add(new SInfoFinderElement(true, extention));
		}
		public Object getReturnValue(Object elem){ return elem; }
		
		private class SInfoFinderElement extends FinderElement{
			SInfoFinderElement(boolean not, String extention){ super(not, extention); }
			public Object getFindValue(Object elem){
				if(!(elem instanceof ScriptInfo)){
					return null;
				}
				return ((ScriptInfo)elem).getExtention();
			}
		}
	}
}
