package jp.wda.gpss.util;

import java.util.ArrayList;

/**
 * ListIuWFNgNXiwpj쐬p[eBeB
 *
 * @version	1.00006	2003/05/29
 * @since		1.00005	2003/05/27
 * @author	amoi
 */
public class FinderConditionInterpreter {
	/* ***********************************************************************>> */;
	/**
	 * 啶߂Aw肳ꂽFinderIuWFNgɐݒ肵܂B<BR>
	 * <BR>
	 * ͈̏ȉ̒ʂłB<BR>
	 * EL[̒llɓF[ L[ == "l" ]<BR>
	 * EL[̒llɓȂF[ L[ != "l" ]<BR>
	 * EL[̒lݒ肳ĂF[ L[ != null ]<BR>
	 * EL[̒lݒ肳ĂȂF[ L[ == null ]<BR>
	 * EĺAnullw肵Ȃꍇɂ́A""ŊKv܂B<BR>
	 * <BR>
	 * ̌w肷ꍇ́Aڑgp邱Ƃo܂B<BR>
	 * ̏ꍇ͈̏ȉ̒ʂłB<BR>
	 * E1łA2F[ 1 & 2 ]<BR>
	 * E1܂́A2F[ 1 | 2 ]<BR>
	 * <BR>
	 * ڑŌ΂ꂽ̌́A{Iɍ߂Ă܂B
	 * ςꍇ́A()gpāAO[vĂB<BR>
	 * <BR>
	 * ȉɌ啶̗܂B<BR>
	 * <B>username == "" & (p.room == "ƕ" | p.system == "ALL")</B><BR>
	 * ̏ꍇAusername""łAp.room"ƕ"܂p.system"ALL"łNCAg܂B<BR>
	 * <BR>
	 * L[̎w@́AeFinderhNX̃hLgQƂĂB
	 * 
	 * @param ret ݒ肷FinderIuWFNg
	 * @param connector ڑ@"&"܂"|"w肵ĂB
	 * @param condition 
	 * @return ݒ肳ꂽFinderIuWFNg
	 * @throws jp.wda.gpss.util.FinderCreatingException 񂪕s̏ꍇ
	 */
	public static Finder interpret(Finder ret, String connector, String condition) throws FinderCreatingException{
		if(ret == null || condition == null || condition.length() == 0){ return ret; }
		
		condition = condition.trim();
		if(condition.charAt(0) == '('){
			return setGroup(ret, connector, condition);
		}
		return next(ret, setCondition(ret, connector, condition), 0);
	}
	
	private static String setCondition(Finder ret, String connector, String condition) throws FinderCreatingException{
		if(condition == null || condition.length() == 0){
			throw new FinderCreatingException("ǉw肳Ă܂B:" + condition);
		}
		if(connector == null){ connector = "&"; }
		if(!connector.equals("&") && !connector.equals("|")){
			throw new FinderCreatingException("ڑɂ\"&\"܂\"|\"ȊO͎̕wł܂B:" + connector);
		}
		
		// "==" / "!=" ʒu擾
		int eqidx = getNextDelimiter(condition, 0, EQUALS);
		if(eqidx < 0){
			throw new FinderCreatingException("\"==\"܂͕s\"!=\"܂B:" + condition);
		}
		boolean not = condition.charAt(eqidx) == '=';
		
		// Ӓl擾
		String column = condition.substring(0, eqidx).trim();
		condition = condition.substring(eqidx + 2).trim();
		
		// EӒl擾
		String value  = null;
		if(condition.indexOf("null") == 0){
			value = null;
			condition = condition.substring(4);
		}else{
			if(condition.charAt(0) != '"'){
				throw new FinderCreatingException("nullȊO̒lꍇ́Al\"\"ŊKv܂B:" + condition);
			}
			int quot = condition.indexOf('\"', 1);
			if(quot < 0){
				throw new FinderCreatingException("l̏I肪܂B:" + condition);
			}
			value = condition.substring(1, quot);
			value = value.replaceAll("&quot;", "\"");
			condition = condition.substring(quot + 1).trim();
		}
		
		ret.setNextFinder("&".equals(connector), not, column, value);
		return condition;
	}
	
	private static Finder setGroup(Finder ret, String connector, String condition) throws FinderCreatingException{
		int lst = lastIndexOfParen(condition);
		
		ret.addGroup("&".equals(connector), interpret(ret.createNewFinder(), "&", condition.substring(1, lst)));
		
		if(lst >= condition.length() - 1){ return ret; }
		return next(ret, condition, lst + 1);
	}
	
	private static int lastIndexOfParen(String condition) throws FinderCreatingException{
		int counter = 0;
		for(int i = 1; i < condition.length(); i++){
			if(condition.charAt(i) == '('){ counter++; continue; }
			if(condition.charAt(i) == ')'){
				if(counter == 0){ return i; }
				counter--;
			}
		}
		throw new FinderCreatingException("()Ă܂B:" + condition);
	}
	
	private static Finder next(Finder ret, String condition, int start) throws FinderCreatingException{
		int idx = getNextDelimiter(condition, start, CONNECTORS);
		if(idx < 0){ return ret; }
			
		String connector = condition.substring(idx, idx + 1);
		condition = condition.substring(idx + 1).trim();
		return interpret(ret, connector, condition);
	}
	
	private static int getNextDelimiter(String condition, int start, ArrayList delimiters){
		int idxQ  = condition.indexOf('"', start);
		int stidx = -1; if(idxQ >= 0){ stidx = condition.indexOf('"', idxQ + 1); }
		
		int idx   = condition.indexOf((String)delimiters.get(0), start);
		if(idxQ >= 0 && idxQ < idx)  { idx   = condition.indexOf((String)delimiters.get(0), stidx); }
		for(int i = 1; i < delimiters.size(); i++){
			int idx2 = condition.indexOf((String)delimiters.get(i), start);
			if(idxQ >= 0 && idxQ < idx2){ idx2 = condition.indexOf((String)delimiters.get(i), stidx); }
			if(idx < 0 || (idx2 >= 0 && idx2 < idx)){ idx = idx2; }
		}
		
		return idx;
	}
	
	private static final ArrayList CONNECTORS;
	private static final ArrayList EQUALS;
	static{
		CONNECTORS = new ArrayList();
		CONNECTORS.add("&");
		CONNECTORS.add("|");
		
		EQUALS = new ArrayList();
		EQUALS.add("==");
		EQUALS.add("!=");
	}
	
	private FinderConditionInterpreter(){ ; }
}
	
