/*
 * Decompiled with CFR 0.152.
 */
package FESI.AST;

import FESI.AST.Node;
import java.util.Stack;

public class JJTEcmaScriptState {
    private Stack nodes = new Stack();
    private Stack marks = new Stack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;

    public boolean nodeCreated() {
        return this.node_created;
    }

    public void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    public Node rootNode() {
        return (Node)this.nodes.elementAt(0);
    }

    public void pushNode(Node node) {
        this.nodes.push(node);
        ++this.sp;
    }

    public Node popNode() {
        if (--this.sp < this.mk) {
            this.mk = (Integer)this.marks.pop();
        }
        return (Node)this.nodes.pop();
    }

    public Node peekNode() {
        return (Node)this.nodes.peek();
    }

    public int nodeArity() {
        return this.sp - this.mk;
    }

    public void clearNodeScope(Node node) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = (Integer)this.marks.pop();
    }

    public void openNodeScope(Node node) {
        this.marks.push(new Integer(this.mk));
        this.mk = this.sp;
        node.jjtOpen();
    }

    public void closeNodeScope(Node node, int n) {
        this.mk = (Integer)this.marks.pop();
        while (n-- > 0) {
            Node node2 = this.popNode();
            node2.jjtSetParent(node);
            node.jjtAddChild(node2, n);
        }
        node.jjtClose();
        this.pushNode(node);
        this.node_created = true;
    }

    public void closeNodeScope(Node node, boolean bl) {
        if (bl) {
            int n = this.nodeArity();
            this.mk = (Integer)this.marks.pop();
            while (n-- > 0) {
                Node node2 = this.popNode();
                node2.jjtSetParent(node);
                node.jjtAddChild(node2, n);
            }
            node.jjtClose();
            this.pushNode(node);
            this.node_created = true;
            return;
        }
        this.mk = (Integer)this.marks.pop();
        this.node_created = false;
    }
}

